/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.org.locationtech.jts.awt;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.algorithm.Orientation;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.CoordinateList;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Geometry;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.GeometryFactory;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.LinearRing;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Polygon;

public class ShapeReader {
    private static final AffineTransform INVERT_Y = AffineTransform.getScaleInstance(1.0, -1.0);
    private GeometryFactory geometryFactory;

    public static Geometry read(PathIterator pathIt, GeometryFactory geomFact) {
        ShapeReader pc = new ShapeReader(geomFact);
        return pc.read(pathIt);
    }

    public static Geometry read(Shape shp, double flatness, GeometryFactory geomFact) {
        PathIterator pathIt = shp.getPathIterator(INVERT_Y, flatness);
        return ShapeReader.read(pathIt, geomFact);
    }

    public ShapeReader(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
    }

    public Geometry read(PathIterator pathIt) {
        List pathPtSeq = ShapeReader.toCoordinates(pathIt);
        ArrayList<Polygon> polys = new ArrayList<Polygon>();
        int seqIndex = 0;
        while (seqIndex < pathPtSeq.size()) {
            Coordinate[] pts = (Coordinate[])pathPtSeq.get(seqIndex);
            LinearRing shell = this.geometryFactory.createLinearRing(pts);
            ++seqIndex;
            ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
            while (seqIndex < pathPtSeq.size() && this.isHole((Coordinate[])pathPtSeq.get(seqIndex))) {
                Coordinate[] holePts = (Coordinate[])pathPtSeq.get(seqIndex);
                LinearRing hole = this.geometryFactory.createLinearRing(holePts);
                holes.add(hole);
                ++seqIndex;
            }
            LinearRing[] holeArray = GeometryFactory.toLinearRingArray(holes);
            polys.add(this.geometryFactory.createPolygon(shell, holeArray));
        }
        return this.geometryFactory.buildGeometry(polys);
    }

    private boolean isHole(Coordinate[] pts) {
        return Orientation.isCCW(pts);
    }

    public static List toCoordinates(PathIterator pathIt) {
        Coordinate[] pts;
        ArrayList<Coordinate[]> coordArrays = new ArrayList<Coordinate[]>();
        while (!pathIt.isDone() && (pts = ShapeReader.nextCoordinateArray(pathIt)) != null) {
            coordArrays.add(pts);
        }
        return coordArrays;
    }

    private static Coordinate[] nextCoordinateArray(PathIterator pathIt) {
        double[] pathPt = new double[6];
        CoordinateList coordList = null;
        boolean isDone = false;
        while (!pathIt.isDone()) {
            int segType = pathIt.currentSegment(pathPt);
            switch (segType) {
                case 0: {
                    if (coordList != null) {
                        isDone = true;
                        break;
                    }
                    coordList = new CoordinateList();
                    coordList.add(new Coordinate(pathPt[0], pathPt[1]));
                    pathIt.next();
                    break;
                }
                case 1: {
                    coordList.add(new Coordinate(pathPt[0], pathPt[1]));
                    pathIt.next();
                    break;
                }
                case 4: {
                    coordList.closeRing();
                    pathIt.next();
                    isDone = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unhandled (non-linear) segment type encountered");
                }
            }
            if (!isDone) continue;
            break;
        }
        return coordList.toCoordinateArray();
    }
}

