/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.prep;

import java.util.List;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Geometry;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Polygonal;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.prep.PreparedPolygon;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.prep.PreparedPolygonPredicate;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.noding.SegmentStringUtil;

class PreparedPolygonContainsProperly
extends PreparedPolygonPredicate {
    public static boolean containsProperly(PreparedPolygon prep, Geometry geom) {
        PreparedPolygonContainsProperly polyInt = new PreparedPolygonContainsProperly(prep);
        return polyInt.containsProperly(geom);
    }

    public PreparedPolygonContainsProperly(PreparedPolygon prepPoly) {
        super(prepPoly);
    }

    public boolean containsProperly(Geometry geom) {
        boolean isTargetGeomInTestArea;
        boolean isAllInPrepGeomAreaInterior = this.isAllTestComponentsInTargetInterior(geom);
        if (!isAllInPrepGeomAreaInterior) {
            return false;
        }
        List lineSegStr = SegmentStringUtil.extractSegmentStrings(geom);
        boolean segsIntersect = this.prepPoly.getIntersectionFinder().intersects(lineSegStr);
        if (segsIntersect) {
            return false;
        }
        return !(geom instanceof Polygonal) || !(isTargetGeomInTestArea = this.isAnyTargetComponentInAreaTest(geom, this.prepPoly.getRepresentativePoints()));
    }
}

