/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.org.locationtech.jts.noding.snapround;

import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Envelope;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.index.ItemVisitor;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.index.SpatialIndex;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.index.chain.MonotoneChain;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.index.chain.MonotoneChainSelectAction;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.index.strtree.STRtree;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.noding.NodedSegmentString;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.noding.SegmentString;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.noding.snapround.HotPixel;

public class MCIndexPointSnapper {
    private STRtree index;

    public MCIndexPointSnapper(SpatialIndex index) {
        this.index = (STRtree)index;
    }

    public boolean snap(HotPixel hotPixel, SegmentString parentEdge, int hotPixelVertexIndex) {
        final Envelope pixelEnv = hotPixel.getSafeEnvelope();
        final HotPixelSnapAction hotPixelSnapAction = new HotPixelSnapAction(hotPixel, parentEdge, hotPixelVertexIndex);
        this.index.query(pixelEnv, new ItemVisitor(){

            @Override
            public void visitItem(Object item) {
                MonotoneChain testChain = (MonotoneChain)item;
                testChain.select(pixelEnv, hotPixelSnapAction);
            }
        });
        return hotPixelSnapAction.isNodeAdded();
    }

    public boolean snap(HotPixel hotPixel) {
        return this.snap(hotPixel, null, -1);
    }

    public static class HotPixelSnapAction
    extends MonotoneChainSelectAction {
        private HotPixel hotPixel;
        private SegmentString parentEdge;
        private int hotPixelVertexIndex;
        private boolean isNodeAdded = false;

        public HotPixelSnapAction(HotPixel hotPixel, SegmentString parentEdge, int hotPixelVertexIndex) {
            this.hotPixel = hotPixel;
            this.parentEdge = parentEdge;
            this.hotPixelVertexIndex = hotPixelVertexIndex;
        }

        public boolean isNodeAdded() {
            return this.isNodeAdded;
        }

        @Override
        public void select(MonotoneChain mc, int startIndex) {
            NodedSegmentString ss = (NodedSegmentString)mc.getContext();
            if (this.parentEdge != null && ss == this.parentEdge && startIndex == this.hotPixelVertexIndex) {
                return;
            }
            this.isNodeAdded = this.hotPixel.addSnappedNode(ss, startIndex);
        }
    }
}

