/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.org.locationtech.jts.operation.valid;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.algorithm.PointLocation;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Envelope;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.LinearRing;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geomgraph.GeometryGraph;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.index.SpatialIndex;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.index.strtree.STRtree;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.operation.valid.IsValidOp;

public class IndexedNestedRingTester {
    private GeometryGraph graph;
    private List rings = new ArrayList();
    private Envelope totalEnv = new Envelope();
    private SpatialIndex index;
    private Coordinate nestedPt;

    public IndexedNestedRingTester(GeometryGraph graph) {
        this.graph = graph;
    }

    public Coordinate getNestedPoint() {
        return this.nestedPt;
    }

    public void add(LinearRing ring) {
        this.rings.add(ring);
        this.totalEnv.expandToInclude(ring.getEnvelopeInternal());
    }

    public boolean isNonNested() {
        this.buildIndex();
        for (int i = 0; i < this.rings.size(); ++i) {
            LinearRing innerRing = (LinearRing)this.rings.get(i);
            Coordinate[] innerRingPts = innerRing.getCoordinates();
            List results = this.index.query(innerRing.getEnvelopeInternal());
            for (int j = 0; j < results.size(); ++j) {
                boolean isInside;
                Coordinate innerRingPt;
                LinearRing searchRing = (LinearRing)results.get(j);
                Coordinate[] searchRingPts = searchRing.getCoordinates();
                if (innerRing == searchRing || !innerRing.getEnvelopeInternal().intersects(searchRing.getEnvelopeInternal()) || (innerRingPt = IsValidOp.findPtNotNode(innerRingPts, searchRing, this.graph)) == null || !(isInside = PointLocation.isInRing(innerRingPt, searchRingPts))) continue;
                this.nestedPt = innerRingPt;
                return false;
            }
        }
        return true;
    }

    private void buildIndex() {
        this.index = new STRtree();
        for (int i = 0; i < this.rings.size(); ++i) {
            LinearRing ring = (LinearRing)this.rings.get(i);
            Envelope env = ring.getEnvelopeInternal();
            this.index.insert(env, ring);
        }
    }
}

