/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.org.locationtech.jts.precision;

import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.algorithm.Distance;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.CoordinateFilter;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.CoordinateSequence;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Geometry;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.LineSegment;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.LineString;

public class SimpleMinimumClearance {
    private Geometry inputGeom;
    private double minClearance;
    private Coordinate[] minClearancePts;

    public static double getDistance(Geometry g) {
        SimpleMinimumClearance rp = new SimpleMinimumClearance(g);
        return rp.getDistance();
    }

    public static Geometry getLine(Geometry g) {
        SimpleMinimumClearance rp = new SimpleMinimumClearance(g);
        return rp.getLine();
    }

    public SimpleMinimumClearance(Geometry geom) {
        this.inputGeom = geom;
    }

    public double getDistance() {
        this.compute();
        return this.minClearance;
    }

    public LineString getLine() {
        this.compute();
        return this.inputGeom.getFactory().createLineString(this.minClearancePts);
    }

    private void compute() {
        if (this.minClearancePts != null) {
            return;
        }
        this.minClearancePts = new Coordinate[2];
        this.minClearance = Double.MAX_VALUE;
        this.inputGeom.apply(new VertexCoordinateFilter(this));
    }

    private void updateClearance(double candidateValue, Coordinate p0, Coordinate p1) {
        if (candidateValue < this.minClearance) {
            this.minClearance = candidateValue;
            this.minClearancePts[0] = new Coordinate(p0);
            this.minClearancePts[1] = new Coordinate(p1);
        }
    }

    private void updateClearance(double candidateValue, Coordinate p, Coordinate seg0, Coordinate seg1) {
        if (candidateValue < this.minClearance) {
            this.minClearance = candidateValue;
            this.minClearancePts[0] = new Coordinate(p);
            LineSegment seg = new LineSegment(seg0, seg1);
            this.minClearancePts[1] = new Coordinate(seg.closestPoint(p));
        }
    }

    private static class ComputeMCCoordinateSequenceFilter
    implements CoordinateSequenceFilter {
        SimpleMinimumClearance smc;
        private Coordinate queryPt;

        public ComputeMCCoordinateSequenceFilter(SimpleMinimumClearance smc, Coordinate queryPt) {
            this.smc = smc;
            this.queryPt = queryPt;
        }

        @Override
        public void filter(CoordinateSequence seq, int i) {
            this.checkVertexDistance(seq.getCoordinate(i));
            if (i > 0) {
                this.checkSegmentDistance(seq.getCoordinate(i - 1), seq.getCoordinate(i));
            }
        }

        private void checkVertexDistance(Coordinate vertex) {
            double vertexDist = vertex.distance(this.queryPt);
            if (vertexDist > 0.0) {
                this.smc.updateClearance(vertexDist, this.queryPt, vertex);
            }
        }

        private void checkSegmentDistance(Coordinate seg0, Coordinate seg1) {
            if (this.queryPt.equals2D(seg0) || this.queryPt.equals2D(seg1)) {
                return;
            }
            double segDist = Distance.pointToSegment(this.queryPt, seg1, seg0);
            if (segDist > 0.0) {
                this.smc.updateClearance(segDist, this.queryPt, seg1, seg0);
            }
        }

        @Override
        public boolean isDone() {
            return false;
        }

        @Override
        public boolean isGeometryChanged() {
            return false;
        }
    }

    private static class VertexCoordinateFilter
    implements CoordinateFilter {
        SimpleMinimumClearance smc;

        public VertexCoordinateFilter(SimpleMinimumClearance smc) {
            this.smc = smc;
        }

        @Override
        public void filter(Coordinate coord) {
            this.smc.inputGeom.apply(new ComputeMCCoordinateSequenceFilter(this.smc, coord));
        }
    }
}

