/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.org.locationtech.jts.shape.fractal;

import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Geometry;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.GeometryFactory;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.LineSegment;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.shape.GeometricShapeBuilder;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.shape.fractal.MortonCode;

public class MortonCurveBuilder
extends GeometricShapeBuilder {
    public MortonCurveBuilder(GeometryFactory geomFactory) {
        super(geomFactory);
        this.extent = null;
    }

    public void setLevel(int level) {
        this.numPts = MortonCode.size(level);
    }

    @Override
    public Geometry getGeometry() {
        int level = MortonCode.level(this.numPts);
        int nPts = MortonCode.size(level);
        double scale = 1.0;
        double baseX = 0.0;
        double baseY = 0.0;
        if (this.extent != null) {
            LineSegment baseLine = this.getSquareBaseLine();
            baseX = baseLine.minX();
            baseY = baseLine.minY();
            double width = baseLine.getLength();
            int maxOrdinate = MortonCode.maxOrdinate(level);
            scale = width / (double)maxOrdinate;
        }
        Coordinate[] pts = new Coordinate[nPts];
        for (int i = 0; i < nPts; ++i) {
            Coordinate pt = MortonCode.decode(i);
            double x = MortonCurveBuilder.transform(pt.getX(), scale, baseX);
            double y = MortonCurveBuilder.transform(pt.getY(), scale, baseY);
            pts[i] = new Coordinate(x, y);
        }
        return this.geomFactory.createLineString(pts);
    }

    private static double transform(double val, double scale, double offset) {
        return val * scale + offset;
    }
}

