/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.org.locationtech.jts.triangulate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.CoordinateArrays;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.CoordinateList;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Envelope;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Geometry;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.GeometryFactory;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.triangulate.IncrementalDelaunayTriangulator;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.triangulate.quadedge.QuadEdgeSubdivision;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.triangulate.quadedge.Vertex;

public class DelaunayTriangulationBuilder {
    private Collection siteCoords;
    private double tolerance = 0.0;
    private QuadEdgeSubdivision subdiv = null;

    public static CoordinateList extractUniqueCoordinates(Geometry geom) {
        if (geom == null) {
            return new CoordinateList();
        }
        Coordinate[] coords = geom.getCoordinates();
        return DelaunayTriangulationBuilder.unique(coords);
    }

    public static CoordinateList unique(Coordinate[] coords) {
        Object[] coordsCopy = CoordinateArrays.copyDeep(coords);
        Arrays.sort(coordsCopy);
        CoordinateList coordList = new CoordinateList((Coordinate[])coordsCopy, false);
        return coordList;
    }

    public static List toVertices(Collection coords) {
        ArrayList<Vertex> verts = new ArrayList<Vertex>();
        for (Coordinate coord : coords) {
            verts.add(new Vertex(coord));
        }
        return verts;
    }

    public static Envelope envelope(Collection coords) {
        Envelope env = new Envelope();
        for (Coordinate coord : coords) {
            env.expandToInclude(coord);
        }
        return env;
    }

    public void setSites(Geometry geom) {
        this.siteCoords = DelaunayTriangulationBuilder.extractUniqueCoordinates(geom);
    }

    public void setSites(Collection coords) {
        this.siteCoords = DelaunayTriangulationBuilder.unique(CoordinateArrays.toCoordinateArray(coords));
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    private void create() {
        if (this.subdiv != null) {
            return;
        }
        Envelope siteEnv = DelaunayTriangulationBuilder.envelope(this.siteCoords);
        List vertices = DelaunayTriangulationBuilder.toVertices(this.siteCoords);
        this.subdiv = new QuadEdgeSubdivision(siteEnv, this.tolerance);
        IncrementalDelaunayTriangulator triangulator = new IncrementalDelaunayTriangulator(this.subdiv);
        triangulator.insertSites(vertices);
    }

    public QuadEdgeSubdivision getSubdivision() {
        this.create();
        return this.subdiv;
    }

    public Geometry getEdges(GeometryFactory geomFact) {
        this.create();
        return this.subdiv.getEdges(geomFact);
    }

    public Geometry getTriangles(GeometryFactory geomFact) {
        this.create();
        return this.subdiv.getTriangles(geomFact);
    }
}

