/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.sink;

import com.vesoft.nebula.client.graph.data.ResultSet;
import com.vesoft.nebula.client.graph.net.Session;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.connector.nebula.shaded.org.slf4j.Logger;
import org.apache.flink.connector.nebula.shaded.org.slf4j.LoggerFactory;
import org.apache.flink.connector.nebula.sink.NebulaBatchExecutor;
import org.apache.flink.connector.nebula.sink.NebulaRowEdgeOutputFormatConverter;
import org.apache.flink.connector.nebula.statement.EdgeExecutionOptions;
import org.apache.flink.connector.nebula.utils.NebulaEdge;
import org.apache.flink.connector.nebula.utils.NebulaEdges;
import org.apache.flink.connector.nebula.utils.VidTypeEnum;
import org.apache.flink.types.Row;

public class NebulaEdgeBatchExecutor
implements NebulaBatchExecutor<Row> {
    private static final Logger LOG = LoggerFactory.getLogger(NebulaEdgeBatchExecutor.class);
    private final EdgeExecutionOptions executionOptions;
    private final List<NebulaEdge> nebulaEdgeList;
    private final NebulaRowEdgeOutputFormatConverter converter;

    public NebulaEdgeBatchExecutor(EdgeExecutionOptions executionOptions, VidTypeEnum vidType, Map<String, Integer> schema) {
        this.executionOptions = executionOptions;
        this.nebulaEdgeList = new ArrayList<NebulaEdge>();
        this.converter = new NebulaRowEdgeOutputFormatConverter(executionOptions, vidType, schema);
    }

    @Override
    public void addToBatch(Row record) {
        NebulaEdge edge = this.converter.createEdge(record, this.executionOptions.getPolicy());
        if (edge == null) {
            return;
        }
        this.nebulaEdgeList.add(edge);
    }

    @Override
    public String executeBatch(Session session) {
        if (this.nebulaEdgeList.size() == 0) {
            return null;
        }
        NebulaEdges nebulaEdges = new NebulaEdges(this.executionOptions.getLabel(), this.executionOptions.getFields(), this.nebulaEdgeList, this.executionOptions.getPolicy(), this.executionOptions.getPolicy());
        String statement = null;
        switch (this.executionOptions.getWriteMode()) {
            case INSERT: {
                statement = nebulaEdges.getInsertStatement();
                break;
            }
            case UPDATE: {
                statement = nebulaEdges.getUpdateStatement();
                break;
            }
            case DELETE: {
                statement = nebulaEdges.getDeleteStatement();
                break;
            }
            default: {
                throw new IllegalArgumentException("write mode is not supported");
            }
        }
        LOG.debug("write statement={}", (Object)statement);
        ResultSet execResult = null;
        try {
            execResult = session.execute(statement);
        }
        catch (Exception e) {
            LOG.error("write data error, ", e);
            this.nebulaEdgeList.clear();
            return statement;
        }
        if (!execResult.isSucceeded()) {
            LOG.error("write data failed: {}", (Object)execResult.getErrorMessage());
            this.nebulaEdgeList.clear();
            return statement;
        }
        LOG.debug("write success");
        this.nebulaEdgeList.clear();
        return null;
    }
}

