/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.statement;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.connector.nebula.statement.ExecutionOptions;
import org.apache.flink.connector.nebula.utils.DataTypeEnum;
import org.apache.flink.connector.nebula.utils.PolicyEnum;
import org.apache.flink.connector.nebula.utils.WriteModeEnum;

public class EdgeExecutionOptions
extends ExecutionOptions {
    private String edge;
    private int srcIndex;
    private int dstIndex;
    private int rankIndex;

    private EdgeExecutionOptions(String graphSpace, String executeStatement, List<String> fields, List<Integer> positions, boolean noColumn, int limit, long startTime, long endTime, int batch, PolicyEnum policy, WriteModeEnum mode, String edge, int srcIndex, int dstIndex, int rankIndex, int batchIntervalMs) {
        super(graphSpace, executeStatement, fields, positions, noColumn, limit, startTime, endTime, batch, policy, mode, batchIntervalMs);
        this.edge = edge;
        this.srcIndex = srcIndex;
        this.dstIndex = dstIndex;
        this.rankIndex = rankIndex;
    }

    public String getEdge() {
        return this.edge;
    }

    public int getSrcIndex() {
        return this.srcIndex;
    }

    public int getDstIndex() {
        return this.dstIndex;
    }

    public int getRankIndex() {
        return this.rankIndex;
    }

    @Override
    public String getLabel() {
        return this.edge;
    }

    @Override
    public DataTypeEnum getDataType() {
        return DataTypeEnum.EDGE;
    }

    public ExecutionOptionBuilder toBuilder() {
        return new ExecutionOptionBuilder().setGraphSpace(this.getGraphSpace()).setExecuteStatement(this.getExecuteStatement()).setEdge(this.getEdge()).setFields(this.getFields()).setPositions(this.getPositions()).setNoColumn(this.isNoColumn()).setLimit(this.getLimit()).setStartTime(this.getStartTime()).setEndTime(this.getEndTime()).setBatchSize(this.getBatchSize()).setPolicy(Optional.ofNullable(this.getPolicy()).map(Objects::toString).orElse(null)).setSrcIndex(this.getSrcIndex()).setDstIndex(this.getDstIndex()).setRankIndex(this.getRankIndex()).setWriteMode(this.getWriteMode()).setBatchIntervalMs(this.getBatchIntervalMs());
    }

    public static class ExecutionOptionBuilder {
        private String graphSpace;
        private String executeStatement;
        private String edge;
        private List<String> fields;
        private List<Integer> positions;
        private boolean noColumn = false;
        private int limit = 2000;
        private long startTime = 0L;
        private long endTime = Long.MAX_VALUE;
        private int batchSize = 2000;
        private int batchIntervalMs = 0;
        private PolicyEnum policy = null;
        private WriteModeEnum mode = WriteModeEnum.INSERT;
        private int srcIndex = -1;
        private int dstIndex = -1;
        private int rankIndex = -1;

        public ExecutionOptionBuilder setGraphSpace(String graphSpace) {
            this.graphSpace = graphSpace;
            return this;
        }

        public ExecutionOptionBuilder setExecuteStatement(String executeStatement) {
            this.executeStatement = executeStatement;
            return this;
        }

        public ExecutionOptionBuilder setEdge(String edge) {
            this.edge = edge;
            return this;
        }

        public ExecutionOptionBuilder setFields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public ExecutionOptionBuilder setPositions(List<Integer> positions) {
            this.positions = positions;
            return this;
        }

        public ExecutionOptionBuilder setNoColumn(boolean noColumn) {
            this.noColumn = noColumn;
            return this;
        }

        public ExecutionOptionBuilder setLimit(int limit) {
            this.limit = limit;
            return this;
        }

        public ExecutionOptionBuilder setStartTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public ExecutionOptionBuilder setEndTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        public ExecutionOptionBuilder setBatchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        @Deprecated
        public ExecutionOptionBuilder setBatch(int batch) {
            return this.setBatchSize(batch);
        }

        public ExecutionOptionBuilder setPolicy(String policy) {
            if (policy != null && !policy.trim().isEmpty()) {
                this.policy = PolicyEnum.valueOf(policy);
            }
            return this;
        }

        public ExecutionOptionBuilder setSrcIndex(int srcIndex) {
            this.srcIndex = srcIndex;
            return this;
        }

        public ExecutionOptionBuilder setDstIndex(int dstIndex) {
            this.dstIndex = dstIndex;
            return this;
        }

        public ExecutionOptionBuilder setRankIndex(int rankIndex) {
            this.rankIndex = rankIndex;
            return this;
        }

        public ExecutionOptionBuilder setWriteMode(WriteModeEnum mode) {
            this.mode = mode;
            return this;
        }

        public ExecutionOptionBuilder setBatchIntervalMs(int batchIntervalMs) {
            this.batchIntervalMs = batchIntervalMs;
            return this;
        }

        @Deprecated
        public EdgeExecutionOptions builder() {
            return this.build();
        }

        public EdgeExecutionOptions build() {
            if (this.graphSpace == null || this.graphSpace.trim().isEmpty()) {
                throw new IllegalArgumentException("graph space can not be empty.");
            }
            if (this.edge == null || this.edge.trim().isEmpty()) {
                throw new IllegalArgumentException("edge can not be empty.");
            }
            return new EdgeExecutionOptions(this.graphSpace, this.executeStatement, this.fields, this.positions, this.noColumn, this.limit, this.startTime, this.endTime, this.batchSize, this.policy, this.mode, this.edge, this.srcIndex, this.dstIndex, this.rankIndex, this.batchIntervalMs);
        }
    }
}

