/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.table;

import com.vesoft.nebula.client.graph.data.DateTimeWrapper;
import com.vesoft.nebula.client.graph.data.DateWrapper;
import com.vesoft.nebula.client.graph.data.TimeWrapper;
import com.vesoft.nebula.client.graph.data.ValueWrapper;
import com.vesoft.nebula.client.storage.data.BaseTableRow;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import org.apache.flink.connector.nebula.source.NebulaConverter;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class NebulaRowDataConverter
implements NebulaConverter<RowData> {
    private final RowType rowType;
    private final NebulaDeserializationConverter[] toInternalConverters;
    private final NebulaSerializationConverter[] toExternalConverters;
    private final LogicalType[] fieldTypes;

    public NebulaRowDataConverter(RowType rowType) {
        this.rowType = (RowType)Preconditions.checkNotNull((Object)rowType);
        this.fieldTypes = (LogicalType[])rowType.getFields().stream().map(RowType.RowField::getType).toArray(LogicalType[]::new);
        this.toInternalConverters = new NebulaDeserializationConverter[rowType.getFieldCount()];
        this.toExternalConverters = new NebulaSerializationConverter[rowType.getFieldCount()];
        for (int i = 0; i < rowType.getFieldCount(); ++i) {
            this.toInternalConverters[i] = this.createInternalConverter(this.fieldTypes[i]);
            this.toExternalConverters[i] = this.createExternalConverter(this.fieldTypes[i]);
        }
    }

    @Override
    public RowData convert(BaseTableRow record) throws UnsupportedEncodingException {
        List<ValueWrapper> values = record.getValues();
        GenericRowData genericRowData = new GenericRowData(this.rowType.getFieldCount());
        for (int pos = 0; pos < this.rowType.getFieldCount(); ++pos) {
            ValueWrapper valueWrapper = values.get(pos);
            if (!valueWrapper.isNull()) {
                try {
                    genericRowData.setField(pos, this.toInternalConverters[pos].deserialize(valueWrapper));
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                continue;
            }
            genericRowData.setField(pos, null);
        }
        return genericRowData;
    }

    public Row toExternal(RowData rowData) throws SQLException {
        Row row = new Row(rowData.getArity());
        for (int i = 0; i < rowData.getArity(); ++i) {
            if (!rowData.isNullAt(i)) {
                this.toExternalConverters[i].serialize(rowData, i, row);
                continue;
            }
            row.setField(i, null);
        }
        return row;
    }

    private NebulaDeserializationConverter createInternalConverter(LogicalType type) {
        switch (type.getTypeRoot()) {
            case NULL: {
                return val -> null;
            }
            case BOOLEAN: {
                return ValueWrapper::asBoolean;
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return ValueWrapper::asLong;
            }
            case FLOAT: 
            case DOUBLE: {
                return ValueWrapper::asDouble;
            }
            case CHAR: 
            case VARCHAR: {
                return val -> val.isGeography() ? StringData.fromString((String)val.asGeography().toString()) : StringData.fromString((String)val.asString());
            }
            case DATE: {
                return val -> {
                    DateWrapper dateWrapper = val.asDate();
                    Date date = Date.valueOf(dateWrapper.toString());
                    return (int)date.toLocalDate().toEpochDay();
                };
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return val -> {
                    TimeWrapper t = val.asTime();
                    LocalTime localTime = LocalTime.of(t.getHour(), t.getMinute(), t.getSecond());
                    Time time = Time.valueOf(localTime);
                    return (int)(time.toLocalTime().toNanoOfDay() / 1000000L);
                };
            }
            case TIMESTAMP_WITH_TIME_ZONE: 
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return val -> {
                    if (val.isDateTime()) {
                        DateTimeWrapper t = val.asDateTime();
                        LocalDateTime localDateTime = LocalDateTime.of((int)t.getYear(), t.getMonth(), (int)t.getDay(), (int)t.getHour(), (int)t.getMinute(), (int)t.getSecond());
                        return TimestampData.fromLocalDateTime((LocalDateTime)localDateTime);
                    }
                    return TimestampData.fromTimestamp((Timestamp)new Timestamp(val.asLong() * 1000L));
                };
            }
        }
        throw new UnsupportedOperationException("Unsupported type:" + type);
    }

    private NebulaSerializationConverter createExternalConverter(LogicalType type) {
        switch (type.getTypeRoot()) {
            case BOOLEAN: {
                return (val, idx, row) -> row.setField(idx, (Object)val.getBoolean(idx));
            }
            case TINYINT: {
                return (val, idx, row) -> row.setField(idx, (Object)val.getByte(idx));
            }
            case SMALLINT: {
                return (val, idx, row) -> row.setField(idx, (Object)val.getShort(idx));
            }
            case INTEGER: {
                return (val, idx, row) -> row.setField(idx, (Object)val.getInt(idx));
            }
            case BIGINT: {
                return (val, idx, row) -> row.setField(idx, (Object)val.getLong(idx));
            }
            case FLOAT: {
                return (val, idx, row) -> row.setField(idx, (Object)Float.valueOf(val.getFloat(idx)));
            }
            case DOUBLE: {
                return (val, idx, row) -> row.setField(idx, (Object)val.getDouble(idx));
            }
            case CHAR: 
            case VARCHAR: {
                return (val, idx, row) -> row.setField(idx, (Object)val.getString(idx).toString());
            }
            case DATE: {
                return (val, idx, row) -> row.setField(idx, (Object)Date.valueOf(LocalDate.ofEpochDay(val.getInt(idx))));
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return (val, idx, row) -> {
                    LocalTime localTime = LocalTime.ofNanoOfDay((long)val.getInt(idx) * 1000000L);
                    row.setField(idx, (Object)localTime.toString());
                };
            }
            case TIMESTAMP_WITH_TIME_ZONE: 
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                int timeStampPrecision = ((TimestampType)type).getPrecision();
                return (val, idx, row) -> row.setField(idx, (Object)Timestamp.from(val.getTimestamp(idx, timeStampPrecision).toInstant()));
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                int localZonedTimeStampPrecision = ((LocalZonedTimestampType)type).getPrecision();
                return (val, idx, row) -> row.setField(idx, (Object)Timestamp.from(val.getTimestamp(idx, localZonedTimeStampPrecision).toInstant()));
            }
        }
        throw new UnsupportedOperationException("Unsupported type:" + type);
    }

    @FunctionalInterface
    static interface NebulaSerializationConverter
    extends Serializable {
        public void serialize(RowData var1, int var2, Row var3) throws SQLException;
    }

    @FunctionalInterface
    static interface NebulaDeserializationConverter
    extends Serializable {
        public Object deserialize(ValueWrapper var1) throws SQLException, UnsupportedEncodingException;
    }
}

