/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.table;

import java.io.IOException;
import org.apache.flink.connector.nebula.connection.NebulaStorageConnectionProvider;
import org.apache.flink.connector.nebula.source.NebulaInputFormat;
import org.apache.flink.connector.nebula.statement.ExecutionOptions;
import org.apache.flink.connector.nebula.table.NebulaRowDataConverter;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class NebulaRowDataInputFormat
extends NebulaInputFormat<RowData> {
    private final LogicalType[] logicalTypes;

    public NebulaRowDataInputFormat(NebulaStorageConnectionProvider storageConnectionProvider, ExecutionOptions executionOptions, LogicalType[] logicalTypes) {
        super(storageConnectionProvider, executionOptions);
        this.logicalTypes = logicalTypes;
    }

    @Override
    public void open(InputSplit inputSplit) throws IOException {
        super.open(inputSplit);
        RowType rowType = RowType.of((LogicalType[])this.logicalTypes);
        this.nebulaConverter = new NebulaRowDataConverter(rowType);
    }
}

