/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.type.basic;

import com.vladmihalcea.hibernate.type.ImmutableType;
import com.vladmihalcea.hibernate.util.ReflectionUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.engine.spi.SessionImplementor;

public class PostgreSQLTSVectorType
extends ImmutableType<String> {
    public PostgreSQLTSVectorType() {
        super(String.class);
    }

    public int[] sqlTypes() {
        return new int[]{1111};
    }

    @Override
    protected String get(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws SQLException {
        return rs.getString(names[0]);
    }

    @Override
    protected void set(PreparedStatement st, String value, int index, SessionImplementor session) throws SQLException {
        if (value == null) {
            st.setNull(index, 1111);
        } else {
            Object holder = ReflectionUtils.newInstance("org.postgresql.util.PGobject");
            ReflectionUtils.invokeSetter(holder, "type", "tsvector");
            ReflectionUtils.invokeSetter(holder, "value", value);
            st.setObject(index, holder);
        }
    }
}

