/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.type.range;

import com.vladmihalcea.hibernate.util.Objects;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;

public final class Range<T extends Comparable>
implements Serializable {
    public static final int LOWER_INCLUSIVE = 2;
    public static final int LOWER_EXCLUSIVE = 4;
    public static final int UPPER_INCLUSIVE = 8;
    public static final int UPPER_EXCLUSIVE = 16;
    public static final int LOWER_INFINITE = 36;
    public static final int UPPER_INFINITE = 80;
    public static final String EMPTY = "empty";
    public static final String INFINITY = "infinity";
    private final T lower;
    private final T upper;
    private final int mask;
    private final Class<T> clazz;

    private Range(T lower, T upper, int mask, Class<T> clazz) {
        this.lower = lower;
        this.upper = upper;
        this.mask = mask;
        this.clazz = clazz;
        if (this.isBounded() && lower.compareTo(upper) > 0) {
            throw new IllegalArgumentException("The lower bound is greater then upper!");
        }
    }

    public static <T extends Comparable<?>> Range<T> closed(T lower, T upper) {
        Objects.requireNonNull(lower);
        Objects.requireNonNull(upper);
        return new Range<T>(lower, upper, 10, lower.getClass());
    }

    public static <T extends Comparable<?>> Range<T> open(T lower, T upper) {
        Objects.requireNonNull(lower);
        Objects.requireNonNull(upper);
        return new Range<T>(lower, upper, 20, lower.getClass());
    }

    public static <T extends Comparable<?>> Range<T> openClosed(T lower, T upper) {
        Objects.requireNonNull(lower);
        Objects.requireNonNull(upper);
        return new Range<T>(lower, upper, 12, lower.getClass());
    }

    public static <T extends Comparable<?>> Range<T> closedOpen(T lower, T upper) {
        Objects.requireNonNull(lower);
        Objects.requireNonNull(upper);
        return new Range<T>(lower, upper, 18, lower.getClass());
    }

    public static <T extends Comparable<?>> Range<T> openInfinite(T lower) {
        Objects.requireNonNull(lower);
        return new Range<Object>(lower, null, 84, (Class<Object>)lower.getClass());
    }

    public static <T extends Comparable<?>> Range<T> closedInfinite(T lower) {
        Objects.requireNonNull(lower);
        return new Range<Object>(lower, null, 82, (Class<Object>)lower.getClass());
    }

    public static <T extends Comparable<?>> Range<T> infiniteOpen(T upper) {
        Objects.requireNonNull(upper);
        return new Range<Object>(null, upper, 52, (Class<Object>)upper.getClass());
    }

    public static <T extends Comparable<?>> Range<T> infiniteClosed(T upper) {
        Objects.requireNonNull(upper);
        return new Range<Object>(null, upper, 44, (Class<Object>)upper.getClass());
    }

    public static <T extends Comparable<?>> Range<T> infinite(Class<T> cls) {
        return new Range<Object>(null, null, 116, cls);
    }

    public static <T extends Comparable> Range<T> ofString(String str, Function<String, T> converter, Class<T> clazz) {
        if (str.equals(EMPTY)) {
            return Range.emptyRange(clazz);
        }
        int mask = str.charAt(0) == '[' ? 2 : 4;
        mask |= str.charAt(str.length() - 1) == ']' ? 8 : 16;
        int delim = str.indexOf(44);
        if (delim == -1) {
            throw new IllegalArgumentException("Cannot find comma character");
        }
        String lowerStr = str.substring(1, delim);
        String upperStr = str.substring(delim + 1, str.length() - 1);
        if (lowerStr.length() == 0 || lowerStr.endsWith(INFINITY)) {
            mask |= 0x24;
        }
        if (upperStr.length() == 0 || upperStr.endsWith(INFINITY)) {
            mask |= 0x50;
        }
        Comparable lower = null;
        Comparable upper = null;
        if ((mask & 0x24) != 36) {
            lower = (Comparable)converter.apply(lowerStr);
        }
        if ((mask & 0x50) != 80) {
            upper = (Comparable)converter.apply(upperStr);
        }
        return new Range<Comparable>(lower, upper, mask, clazz);
    }

    public static Range<BigDecimal> bigDecimalRange(String range) {
        return Range.ofString(range, new Function<String, BigDecimal>(){

            @Override
            public BigDecimal apply(String s) {
                return new BigDecimal(s);
            }
        }, BigDecimal.class);
    }

    public static Range<Integer> integerRange(String range) {
        return Range.ofString(range, new Function<String, Integer>(){

            @Override
            public Integer apply(String s) {
                return Integer.parseInt(s);
            }
        }, Integer.class);
    }

    public static Range<Long> longRange(String range) {
        return Range.ofString(range, new Function<String, Long>(){

            @Override
            public Long apply(String s) {
                return Long.parseLong(s);
            }
        }, Long.class);
    }

    private static Function<String, String> unquote() {
        return new Function<String, String>(){

            @Override
            public String apply(String s) {
                if (s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
                    return s.substring(1, s.length() - 1);
                }
                return s;
            }
        };
    }

    private boolean isBounded() {
        return !this.hasMask(36) && !this.hasMask(80);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range range = (Range)o;
        return this.mask == range.mask && Objects.equals(this.lower, range.lower) && Objects.equals(this.upper, range.upper) && Objects.equals(this.clazz, range.clazz);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.lower, this.upper, this.mask, this.clazz});
    }

    public String toString() {
        return "Range{lower=" + this.lower + ", upper=" + this.upper + ", mask=" + this.mask + ", clazz=" + this.clazz + '}';
    }

    public boolean hasMask(int flag) {
        return (this.mask & flag) == flag;
    }

    public boolean isLowerBoundClosed() {
        return this.hasLowerBound() && this.hasMask(2);
    }

    public boolean isUpperBoundClosed() {
        return this.hasUpperBound() && this.hasMask(8);
    }

    public boolean hasLowerBound() {
        return !this.hasMask(36);
    }

    public boolean hasUpperBound() {
        return !this.hasMask(80);
    }

    public T lower() {
        return this.lower;
    }

    public T upper() {
        return this.upper;
    }

    public boolean contains(T point) {
        boolean l = this.hasLowerBound();
        boolean u = this.hasUpperBound();
        if (l && u) {
            boolean inLower;
            boolean bl = this.hasMask(2) ? this.lower.compareTo(point) <= 0 : (inLower = this.lower.compareTo(point) < 0);
            boolean inUpper = this.hasMask(8) ? this.upper.compareTo(point) >= 0 : this.upper.compareTo(point) > 0;
            return inLower && inUpper;
        }
        if (l) {
            return this.hasMask(2) ? this.lower.compareTo(point) <= 0 : this.lower.compareTo(point) < 0;
        }
        if (u) {
            return this.hasMask(8) ? this.upper.compareTo(point) >= 0 : this.upper.compareTo(point) > 0;
        }
        return true;
    }

    public boolean contains(Range<T> range) {
        return !(range.hasLowerBound() && !this.contains(range.lower) || range.hasUpperBound() && !this.contains(range.upper));
    }

    public String asString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.hasMask(2) ? (char)'[' : '(').append(this.hasLowerBound() ? this.boundToString().apply(this.lower) : "").append(",").append(this.hasUpperBound() ? this.boundToString().apply(this.upper) : "").append(this.hasMask(8) ? (char)']' : ')');
        return sb.toString();
    }

    private Function<T, String> boundToString() {
        return new Function<T, String>(){

            @Override
            public String apply(T t) {
                return t.toString();
            }
        };
    }

    Class<T> getClazz() {
        return this.clazz;
    }

    public static <R extends Comparable<R>> Range<R> emptyRange(Class<R> clazz) {
        return new Range<Object>(null, null, 116, clazz);
    }

    public static interface Function<T, R> {
        public R apply(T var1);
    }
}

