/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.util;

import java.io.InputStream;
import java.net.URL;

public final class ClassLoaderUtils {
    private ClassLoaderUtils() {
        throw new UnsupportedOperationException("ClassLoaderUtils is not instantiable!");
    }

    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader != null ? classLoader : ClassLoaderUtils.class.getClassLoader();
    }

    public static <T> Class<T> loadClass(String className) throws ClassNotFoundException {
        return ClassLoaderUtils.getClassLoader().loadClass(className);
    }

    public static boolean findClass(String className) {
        try {
            return ClassLoaderUtils.getClassLoader().loadClass(className) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    public static URL getResource(String resourceName) {
        return ClassLoaderUtils.getClassLoader().getResource(resourceName);
    }

    public static InputStream getResourceAsStream(String resourceName) {
        return ClassLoaderUtils.getClassLoader().getResourceAsStream(resourceName);
    }
}

