/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.type.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vladmihalcea.hibernate.type.util.ClassLoaderUtils;
import com.vladmihalcea.hibernate.type.util.JsonSerializer;
import com.vladmihalcea.hibernate.type.util.JsonSerializerSupplier;
import com.vladmihalcea.hibernate.type.util.LogUtils;
import com.vladmihalcea.hibernate.type.util.ObjectMapperSupplier;
import com.vladmihalcea.hibernate.type.util.ObjectMapperWrapper;
import com.vladmihalcea.hibernate.type.util.ReflectionUtils;
import com.vladmihalcea.hibernate.type.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.function.Supplier;
import javax.persistence.EntityManagerFactory;
import org.hibernate.cfg.Environment;

public class Configuration {
    public static final Configuration INSTANCE = new Configuration();
    public static final String PROPERTIES_FILE_PATH = "hibernate-types.properties.path";
    public static final String PROPERTIES_FILE_NAME = "hibernate-types.properties";
    private final Properties properties = Environment.getProperties();
    private static boolean bannerPrinted = false;

    private Configuration() {
        this.load();
        this.printBanner();
    }

    private void load() {
        InputStream propertiesInputStream = null;
        try {
            propertiesInputStream = this.propertiesInputStream();
            if (propertiesInputStream != null) {
                this.properties.load(propertiesInputStream);
            }
        }
        catch (IOException e) {
            LogUtils.LOGGER.error("Can't load properties", (Throwable)e);
        }
        finally {
            try {
                if (propertiesInputStream != null) {
                    propertiesInputStream.close();
                }
            }
            catch (IOException e) {
                LogUtils.LOGGER.error("Can't close the properties InputStream", (Throwable)e);
            }
        }
    }

    private InputStream propertiesInputStream() throws IOException {
        String propertiesFilePath = System.getProperty(PROPERTIES_FILE_PATH);
        URL propertiesFileUrl = null;
        if (propertiesFilePath != null) {
            block6: {
                try {
                    propertiesFileUrl = new URL(propertiesFilePath);
                }
                catch (MalformedURLException ignore) {
                    File f;
                    propertiesFileUrl = ClassLoaderUtils.getResource(propertiesFilePath);
                    if (propertiesFileUrl != null || !(f = new File(propertiesFilePath)).exists() || !f.isFile()) break block6;
                    try {
                        propertiesFileUrl = f.toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        LogUtils.LOGGER.error("The property " + propertiesFilePath + " can't be resolved to either a URL, a classpath resource or a File");
                    }
                }
            }
            if (propertiesFileUrl != null) {
                return propertiesFileUrl.openStream();
            }
        }
        return ClassLoaderUtils.getResourceAsStream(PROPERTIES_FILE_NAME);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ObjectMapperWrapper getObjectMapperWrapper() {
        Object jsonSerializerPropertyInstance;
        Object objectMapperPropertyInstance = this.instantiateClass(PropertyKey.JACKSON_OBJECT_MAPPER);
        ObjectMapperWrapper objectMapperWrapper = new ObjectMapperWrapper();
        if (objectMapperPropertyInstance != null) {
            ObjectMapper objectMapper;
            if (objectMapperPropertyInstance instanceof ObjectMapperSupplier) {
                objectMapper = ((ObjectMapperSupplier)objectMapperPropertyInstance).get();
                if (objectMapper != null) {
                    objectMapperWrapper = new ObjectMapperWrapper(objectMapper);
                }
            } else if (objectMapperPropertyInstance instanceof Supplier) {
                Supplier objectMapperSupplier = (Supplier)objectMapperPropertyInstance;
                objectMapperWrapper = new ObjectMapperWrapper((ObjectMapper)objectMapperSupplier.get());
            } else if (objectMapperPropertyInstance instanceof ObjectMapper) {
                objectMapper = (ObjectMapper)objectMapperPropertyInstance;
                objectMapperWrapper = new ObjectMapperWrapper(objectMapper);
            }
        }
        if ((jsonSerializerPropertyInstance = this.instantiateClass(PropertyKey.JSON_SERIALIZER)) != null) {
            JsonSerializer jsonSerializer = null;
            if (jsonSerializerPropertyInstance instanceof JsonSerializerSupplier) {
                jsonSerializer = ((JsonSerializerSupplier)jsonSerializerPropertyInstance).get();
            } else if (jsonSerializerPropertyInstance instanceof Supplier) {
                Supplier jsonSerializerSupplier = (Supplier)jsonSerializerPropertyInstance;
                jsonSerializer = (JsonSerializer)jsonSerializerSupplier.get();
            } else if (jsonSerializerPropertyInstance instanceof JsonSerializer) {
                jsonSerializer = (JsonSerializer)jsonSerializerPropertyInstance;
            }
            if (jsonSerializer != null) {
                objectMapperWrapper.setJsonSerializer(jsonSerializer);
            }
        }
        return objectMapperWrapper;
    }

    public Integer integerProperty(PropertyKey propertyKey) {
        Integer value = null;
        String property = this.properties.getProperty(propertyKey.getKey());
        if (property != null) {
            value = Integer.valueOf(property);
        }
        return value;
    }

    public Long longProperty(PropertyKey propertyKey) {
        Long value = null;
        String property = this.properties.getProperty(propertyKey.getKey());
        if (property != null) {
            value = Long.valueOf(property);
        }
        return value;
    }

    public Boolean booleanProperty(PropertyKey propertyKey) {
        Boolean value = null;
        String property = this.properties.getProperty(propertyKey.getKey());
        if (property != null) {
            value = Boolean.valueOf(property);
        }
        return value;
    }

    public <T> Class<T> classProperty(PropertyKey propertyKey) {
        Class<T> clazz = null;
        String property = this.properties.getProperty(propertyKey.getKey());
        if (property != null) {
            try {
                return ClassLoaderUtils.loadClass(property);
            }
            catch (ClassNotFoundException e) {
                LogUtils.LOGGER.error("Couldn't load the " + property + " class given by the " + (Object)((Object)propertyKey) + " property", (Throwable)e);
            }
        }
        return clazz;
    }

    private <T> T instantiateClass(PropertyKey propertyKey) {
        T object = null;
        String property = this.properties.getProperty(propertyKey.getKey());
        if (property != null) {
            try {
                Class clazz = ClassLoaderUtils.loadClass(property);
                LogUtils.LOGGER.debug("Instantiate {}", clazz);
                object = clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                LogUtils.LOGGER.error("Couldn't load the " + property + " class given by the " + (Object)((Object)propertyKey) + " property", (Throwable)e);
            }
            catch (InstantiationException e) {
                LogUtils.LOGGER.error("Couldn't instantiate the " + property + " class given by the " + (Object)((Object)propertyKey) + " property", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LogUtils.LOGGER.error("Couldn't access the " + property + " class given by the " + (Object)((Object)propertyKey) + " property", (Throwable)e);
            }
        }
        return object;
    }

    private void printBanner() {
        if (this.isHypersistenceOptimizer() || bannerPrinted) {
            return;
        }
        String printBannerValue = this.properties.getProperty(PropertyKey.PRINT_BANNER.getKey());
        if (printBannerValue != null && !Boolean.valueOf(printBannerValue).booleanValue()) {
            return;
        }
        LogUtils.LOGGER.info(StringUtils.join(StringUtils.LINE_SEPARATOR, "This framework is proudly powered by:", "", ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>", " _    _                           _     _", "| |  | |                         (_)   | |", "| |__| |_   _ _ __   ___ _ __ ___ _ ___| |_ ___ _ __   ___ ___", "|  __  | | | | '_ \\ / _ \\ '__/ __| / __| __/ _ \\ '_ \\ / __/ _ \\", "| |  | | |_| | |_) |  __/ |  \\__ \\ \\__ \\ ||  __/ | | | (_|  __/", "|_|  |_|\\__, | .__/ \\___|_|  |___/_|___/\\__\\___|_| |_|\\___\\___|", "         __/ | |", "        |___/|_|", "", "At Hypersistence, we only build amazing tools, like Hibernate Types, Flexy Pool, or Hypersistence Optimizer.", "", "What if there were a tool that could automatically detect JPA and Hibernate performance issues?", "", "Hypersistence Optimizer is that tool! For more details, go to: ", "", "https://vladmihalcea.com/hypersistence-optimizer/", "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<", ""));
        bannerPrinted = true;
    }

    private boolean isHypersistenceOptimizer() {
        try {
            Class licenseClass = ReflectionUtils.getClassOrNull("io.hypersistence.optimizer.core.License");
            if (licenseClass != null) {
                Class jpaConfigClass = ReflectionUtils.getClassOrNull("io.hypersistence.optimizer.core.config.JpaConfig");
                Object jpaConfig = ReflectionUtils.newInstance(jpaConfigClass, new Object[]{null}, new Class[]{EntityManagerFactory.class});
                Object license = ReflectionUtils.newInstance(licenseClass, new Object[]{jpaConfig}, new Class[]{ReflectionUtils.getClassOrNull("io.hypersistence.optimizer.core.LicenseConfig")});
                Properties properties = (Properties)ReflectionUtils.invokeGetter(license, "properties");
                Class propertyClass = ReflectionUtils.getClassOrNull("io.hypersistence.optimizer.core.License$Property");
                Object trialVersionKey = Enum.valueOf(propertyClass, "TRIAL_VERSION");
                Object validUntilMillisKey = Enum.valueOf(propertyClass, "VALID_UNTIL_MILLIS");
                boolean trialVersion = Boolean.parseBoolean(properties.getProperty((String)ReflectionUtils.invokeGetter(trialVersionKey, "key")));
                long validUntilMillis = Long.parseLong(properties.getProperty((String)ReflectionUtils.invokeGetter(validUntilMillisKey, "key")));
                if (!trialVersion && validUntilMillis > System.currentTimeMillis()) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static enum PropertyKey {
        JACKSON_OBJECT_MAPPER("hibernate.types.jackson.object.mapper"),
        JSON_SERIALIZER("hibernate.types.json.serializer"),
        PRINT_BANNER("hibernate.types.print.banner");

        private final String key;

        private PropertyKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

