/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.type.basic;

import java.io.Serializable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;

public class Inet
implements Serializable {
    private final String address;

    public Inet(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Objects.equals(this.address, ((Inet)Inet.class.cast((Object)o)).address);
    }

    public int hashCode() {
        return Objects.hash(this.address);
    }

    public InetAddress toInetAddress() {
        try {
            String host = this.address.replaceAll("\\/.*$", "");
            return Inet4Address.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
    }
}

