/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.type.interval;

import com.vladmihalcea.hibernate.type.ImmutableType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.postgresql.util.PGInterval;

public class PostgreSQLIntervalType
extends ImmutableType<Duration> {
    public static final PostgreSQLIntervalType INSTANCE = new PostgreSQLIntervalType();

    public PostgreSQLIntervalType() {
        super(Duration.class);
    }

    @Override
    protected Duration get(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws SQLException {
        PGInterval interval = (PGInterval)rs.getObject(names[0]);
        if (interval == null) {
            return null;
        }
        int days = interval.getDays();
        int hours = interval.getHours();
        int minutes = interval.getMinutes();
        double seconds = interval.getSeconds();
        return Duration.ofDays(days).plus((long)hours, ChronoUnit.HOURS).plus((long)minutes, ChronoUnit.MINUTES).plus((long)Math.floor(seconds), ChronoUnit.SECONDS);
    }

    @Override
    protected void set(PreparedStatement st, Duration value, int index, SharedSessionContractImplementor session) throws SQLException {
        if (value == null) {
            st.setNull(index, 1111);
        } else {
            int days = (int)value.toDays();
            int hours = (int)(value.toHours() % 24L);
            int minutes = (int)(value.toMinutes() % 60L);
            double seconds = value.getSeconds() % 60L;
            st.setObject(index, new PGInterval(0, 0, days, hours, minutes, seconds));
        }
    }

    public int[] sqlTypes() {
        return new int[]{1111};
    }
}

