/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.type.array.internal;

import com.vladmihalcea.hibernate.type.array.internal.AbstractArrayTypeDescriptor;
import com.vladmihalcea.hibernate.type.array.internal.ArrayUtil;
import com.vladmihalcea.hibernate.type.util.ReflectionUtils;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;

public class ListArrayTypeDescriptor
extends AbstractArrayTypeDescriptor<Object> {
    private String sqlArrayType;

    public ListArrayTypeDescriptor() {
        super(Object.class, new MutableMutabilityPlan<Object>(){

            protected Object deepCopyNotNull(Object value) {
                if (value instanceof List) {
                    Object[] array = ((List)value).toArray();
                    return ArrayUtil.asList((Object[])ArrayUtil.deepCopy(array));
                }
                if (value.getClass().isArray()) {
                    Object[] array = (Object[])value;
                    return ArrayUtil.deepCopy(array);
                }
                throw new UnsupportedOperationException("The provided " + value + " is not a List!");
            }

            public Object assemble(Serializable cached) {
                if (cached != null && cached.getClass().isArray()) {
                    Object[] array = (Object[])cached;
                    return Arrays.asList(array);
                }
                return super.assemble(cached);
            }
        });
    }

    @Override
    protected String getSqlArrayType() {
        return this.sqlArrayType;
    }

    @Override
    public Object unwrap(Object value, Class type, WrapperOptions options) {
        if (value instanceof Object[]) {
            return value;
        }
        if (value instanceof List) {
            return super.unwrap(((List)value).toArray(), type, options);
        }
        throw new UnsupportedOperationException("The provided " + value + " is not a Object[] or List!");
    }

    @Override
    public Object wrap(Object value, WrapperOptions options) {
        Object wrappedObject = super.wrap(value, options);
        ArrayList list = null;
        if (wrappedObject != null) {
            list = new ArrayList();
            if (wrappedObject instanceof Object[]) {
                Object[] wrappedArray = (Object[])wrappedObject;
                Collections.addAll(list, wrappedArray);
            } else {
                throw new UnsupportedOperationException("The wrapped object " + value + " is not an Object[]!");
            }
        }
        return list;
    }

    @Override
    public boolean areEqual(Object one, Object another) {
        if (one == another) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        if (one instanceof List && another instanceof List) {
            return ArrayUtil.isEquals(((List)one).toArray(), ((List)another).toArray());
        }
        if (one instanceof Object[] && another instanceof Object[]) {
            return ArrayUtil.isEquals(one, another);
        }
        throw new UnsupportedOperationException("The provided " + one + " and " + another + " are not Object[] or List!");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setParameterValues(Properties parameters) {
        String property;
        Class entityClass = ReflectionUtils.getClass(parameters.getProperty("org.hibernate.type.ParameterType.entityClass"));
        Type memberGenericType = ReflectionUtils.getMemberGenericTypeOrNull(entityClass, property = parameters.getProperty("org.hibernate.type.ParameterType.propertyName"));
        if (!(memberGenericType instanceof ParameterizedType)) throw new UnsupportedOperationException("The property " + property + " in the " + entityClass + " entity is not parameterized!");
        ParameterizedType parameterizedType = (ParameterizedType)memberGenericType;
        Class arrayElementClass = ReflectionUtils.getClass(parameterizedType.getActualTypeArguments()[0].getTypeName());
        this.setArrayObjectClass(arrayElementClass.isArray() ? arrayElementClass : ArrayUtil.toArrayClass(arrayElementClass));
        this.sqlArrayType = parameters.getProperty("sql_array_type");
        if (this.sqlArrayType != null) return;
        if (Integer.class.isAssignableFrom(arrayElementClass)) {
            this.sqlArrayType = "integer";
            return;
        } else if (Long.class.isAssignableFrom(arrayElementClass)) {
            this.sqlArrayType = "bigint";
            return;
        } else if (Double.class.isAssignableFrom(arrayElementClass)) {
            this.sqlArrayType = "float8";
            return;
        } else if (String.class.isAssignableFrom(arrayElementClass)) {
            this.sqlArrayType = "text";
            return;
        } else if (UUID.class.isAssignableFrom(arrayElementClass)) {
            this.sqlArrayType = "uuid";
            return;
        } else {
            if (!Date.class.isAssignableFrom(arrayElementClass)) throw new UnsupportedOperationException("The " + arrayElementClass + " is not supported yet!");
            this.sqlArrayType = "timestamp";
        }
    }
}

