/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.type.basic;

import com.vladmihalcea.hibernate.type.ImmutableType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;

public class NullableCharacterType
extends ImmutableType<Character> {
    public static final NullableCharacterType INSTANCE = new NullableCharacterType();

    public NullableCharacterType() {
        super(Character.class);
    }

    public int[] sqlTypes() {
        return new int[]{1};
    }

    @Override
    public Character get(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws SQLException {
        String value = rs.getString(names[0]);
        return value != null && value.length() > 0 ? Character.valueOf(value.charAt(0)) : null;
    }

    @Override
    public void set(PreparedStatement st, Character value, int index, SharedSessionContractImplementor session) throws SQLException {
        if (value == null) {
            st.setNull(index, 1);
        } else {
            st.setString(index, String.valueOf(value));
        }
    }
}

