/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.type.range.guava;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import com.vladmihalcea.hibernate.type.ImmutableType;
import com.vladmihalcea.hibernate.type.util.ReflectionUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.Properties;
import java.util.function.Function;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.annotations.common.reflection.java.JavaXMember;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.usertype.DynamicParameterizedType;
import org.postgresql.util.PGobject;

public class PostgreSQLGuavaRangeType
extends ImmutableType<Range>
implements DynamicParameterizedType {
    private static final DateTimeFormatter LOCAL_DATE_TIME = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss[.SSSSSS]");
    private static final DateTimeFormatter ZONE_DATE_TIME = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").optionalStart().appendPattern(".").appendFraction(ChronoField.NANO_OF_SECOND, 1, 6, false).optionalEnd().appendPattern("X").toFormatter();
    public static final PostgreSQLGuavaRangeType INSTANCE = new PostgreSQLGuavaRangeType();
    private Type type;

    public PostgreSQLGuavaRangeType() {
        super(Range.class);
    }

    public int[] sqlTypes() {
        return new int[]{1111};
    }

    @Override
    protected Range get(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws SQLException {
        PGobject pgObject = (PGobject)rs.getObject(names[0]);
        if (pgObject == null) {
            return null;
        }
        String type = pgObject.getType();
        String value = pgObject.getValue();
        switch (type) {
            case "int4range": {
                return PostgreSQLGuavaRangeType.integerRange(value);
            }
            case "int8range": {
                return PostgreSQLGuavaRangeType.longRange(value);
            }
            case "numrange": {
                return PostgreSQLGuavaRangeType.bigDecimalRange(value);
            }
            case "tsrange": {
                return PostgreSQLGuavaRangeType.localDateTimeRange(value);
            }
            case "tstzrange": {
                return PostgreSQLGuavaRangeType.zonedDateTimeRange(value);
            }
            case "daterange": {
                return PostgreSQLGuavaRangeType.localDateRange(value);
            }
        }
        throw new IllegalStateException("The range type [" + type + "] is not supported!");
    }

    @Override
    protected void set(PreparedStatement st, Range range, int index, SharedSessionContractImplementor session) throws SQLException {
        if (range == null) {
            st.setNull(index, 1111);
        } else {
            PGobject object = new PGobject();
            object.setType(PostgreSQLGuavaRangeType.determineRangeType(range));
            object.setValue(this.asString(range));
            st.setObject(index, object);
        }
    }

    private static String determineRangeType(Range<?> range) {
        Comparable anyEndpoint = range.hasLowerBound() ? range.lowerEndpoint() : range.upperEndpoint();
        Class<?> clazz = anyEndpoint.getClass();
        if (clazz.equals(Integer.class)) {
            return "int4range";
        }
        if (clazz.equals(Long.class)) {
            return "int8range";
        }
        if (clazz.equals(BigDecimal.class)) {
            return "numrange";
        }
        if (clazz.equals(LocalDateTime.class)) {
            return "tsrange";
        }
        if (clazz.equals(ZonedDateTime.class)) {
            return "tstzrange";
        }
        if (clazz.equals(LocalDate.class)) {
            return "daterange";
        }
        throw new IllegalStateException("The class [" + clazz.getName() + "] is not supported!");
    }

    public static <T extends Comparable> Range<T> ofString(String str, Function<String, T> converter, Class<T> cls) {
        BoundType lowerBound = str.charAt(0) == '[' ? BoundType.CLOSED : BoundType.OPEN;
        BoundType upperBound = str.charAt(str.length() - 1) == ']' ? BoundType.CLOSED : BoundType.OPEN;
        int delim = str.indexOf(44);
        if (delim == -1) {
            throw new IllegalArgumentException("Cannot find comma character");
        }
        String lowerStr = str.substring(1, delim);
        String upperStr = str.substring(delim + 1, str.length() - 1);
        Comparable lower = null;
        Comparable upper = null;
        if (lowerStr.length() > 0) {
            lower = (Comparable)converter.apply(lowerStr);
        }
        if (upperStr.length() > 0) {
            upper = (Comparable)converter.apply(upperStr);
        }
        if (lowerStr.length() == 0) {
            return upperBound == BoundType.CLOSED ? Range.atMost((Comparable)upper) : Range.lessThan((Comparable)upper);
        }
        if (upperStr.length() == 0) {
            return lowerBound == BoundType.CLOSED ? Range.atLeast((Comparable)upper) : Range.greaterThan((Comparable)upper);
        }
        return Range.range((Comparable)lower, (BoundType)lowerBound, (Comparable)upper, (BoundType)upperBound);
    }

    public static Range<BigDecimal> bigDecimalRange(String range) {
        return PostgreSQLGuavaRangeType.ofString(range, BigDecimal::new, BigDecimal.class);
    }

    public static Range<Integer> integerRange(String range) {
        return PostgreSQLGuavaRangeType.ofString(range, Integer::parseInt, Integer.class);
    }

    public static Range<Long> longRange(String range) {
        return PostgreSQLGuavaRangeType.ofString(range, Long::parseLong, Long.class);
    }

    public static Range<LocalDateTime> localDateTimeRange(String range) {
        return PostgreSQLGuavaRangeType.ofString(range, PostgreSQLGuavaRangeType.parseLocalDateTime().compose(PostgreSQLGuavaRangeType.unquote()), LocalDateTime.class);
    }

    public static Range<LocalDate> localDateRange(String range) {
        Function<String, LocalDate> parseLocalDate = LocalDate::parse;
        return PostgreSQLGuavaRangeType.ofString(range, parseLocalDate.compose(PostgreSQLGuavaRangeType.unquote()), LocalDate.class);
    }

    public static Range<ZonedDateTime> zonedDateTimeRange(String rangeStr) {
        ZoneId upperZone;
        ZoneId lowerZone;
        Range<ZonedDateTime> range = PostgreSQLGuavaRangeType.ofString(rangeStr, PostgreSQLGuavaRangeType.parseZonedDateTime().compose(PostgreSQLGuavaRangeType.unquote()), ZonedDateTime.class);
        if (range.hasLowerBound() && range.hasUpperBound() && !(lowerZone = ((ZonedDateTime)range.lowerEndpoint()).getZone()).equals(upperZone = ((ZonedDateTime)range.upperEndpoint()).getZone())) {
            long zoneDriftSeconds;
            Duration lowerDst = ZoneId.systemDefault().getRules().getDaylightSavings(((ZonedDateTime)range.lowerEndpoint()).toInstant());
            Duration upperDst = ZoneId.systemDefault().getRules().getDaylightSavings(((ZonedDateTime)range.upperEndpoint()).toInstant());
            long dstSeconds = upperDst.minus(lowerDst).getSeconds();
            if (dstSeconds < 0L) {
                dstSeconds *= -1L;
            }
            if ((zoneDriftSeconds = (long)(((ZoneOffset)lowerZone).getTotalSeconds() - ((ZoneOffset)upperZone).getTotalSeconds())) < 0L) {
                zoneDriftSeconds *= -1L;
            }
            if (dstSeconds != zoneDriftSeconds) {
                throw new IllegalArgumentException("The upper and lower bounds must be in same time zone!");
            }
        }
        return range;
    }

    private static Function<String, LocalDateTime> parseLocalDateTime() {
        return str -> {
            try {
                return LocalDateTime.parse(str, LOCAL_DATE_TIME);
            }
            catch (DateTimeParseException e) {
                return LocalDateTime.parse(str);
            }
        };
    }

    private static Function<String, ZonedDateTime> parseZonedDateTime() {
        return s -> {
            try {
                return ZonedDateTime.parse(s, ZONE_DATE_TIME);
            }
            catch (DateTimeParseException e) {
                return ZonedDateTime.parse(s);
            }
        };
    }

    private static Function<String, String> unquote() {
        return s -> {
            if (s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
                return s.substring(1, s.length() - 1);
            }
            return s;
        };
    }

    public String asString(Range range) {
        StringBuilder sb = new StringBuilder();
        sb.append(range.lowerBoundType() == BoundType.CLOSED ? (char)'[' : '(').append(range.hasLowerBound() ? this.asString(range.lowerEndpoint()) : "").append(",").append(range.hasUpperBound() ? this.asString(range.upperEndpoint()) : "").append(range.upperBoundType() == BoundType.CLOSED ? (char)']' : ')');
        return sb.toString();
    }

    private String asString(Object value) {
        if (value instanceof ZonedDateTime) {
            return ZONE_DATE_TIME.format((ZonedDateTime)value);
        }
        return value.toString();
    }

    public void setParameterValues(Properties parameters) {
        XProperty xProperty = (XProperty)parameters.get("org.hibernate.type.ParameterType.xproperty");
        this.type = xProperty instanceof JavaXMember ? (Type)ReflectionUtils.invokeGetter(xProperty, "javaType") : ((DynamicParameterizedType.ParameterType)parameters.get("org.hibernate.type.ParameterType")).getReturnedClass();
    }

    public Class<?> getElementType() {
        return this.type instanceof ParameterizedType ? (Class)((ParameterizedType)this.type).getActualTypeArguments()[0] : null;
    }
}

