/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.type.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.transform.ResultTransformer;

public class MapResultTransformer<K, V>
implements ResultTransformer {
    public static final String KEY_ALIAS = "map_key";
    public static final String VALUE_ALIAS = "map_value";
    private Map<K, V> result = new HashMap();

    public Object transformTuple(Object[] tuple, String[] aliases) {
        int keyOrdinal = -1;
        int valueOrdinal = -1;
        for (int i = 0; i < aliases.length; ++i) {
            String alias = aliases[i];
            if (KEY_ALIAS.equalsIgnoreCase(alias)) {
                keyOrdinal = i;
                continue;
            }
            if (!VALUE_ALIAS.equalsIgnoreCase(alias)) continue;
            valueOrdinal = i;
        }
        if (keyOrdinal >= 0) {
            if (valueOrdinal < 0) {
                throw new IllegalArgumentException("A key column alias was given but no value column alias was found!");
            }
        } else {
            if (valueOrdinal >= 0) {
                throw new IllegalArgumentException("A value column alias was given but no key column alias was found!");
            }
            keyOrdinal = 0;
            valueOrdinal = 1;
        }
        Object key = tuple[keyOrdinal];
        Object value = tuple[valueOrdinal];
        this.result.put(key, value);
        return tuple;
    }

    public List transformList(List tuples) {
        return Collections.singletonList(this.result);
    }
}

