/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.type.util;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.vladmihalcea.hibernate.type.util.JsonSerializer;
import com.vladmihalcea.hibernate.type.util.ObjectMapperWrapper;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import org.hibernate.internal.util.SerializationHelper;

public class ObjectMapperJsonSerializer
implements JsonSerializer {
    private final ObjectMapperWrapper objectMapperWrapper;

    public ObjectMapperJsonSerializer(ObjectMapperWrapper objectMapperWrapper) {
        this.objectMapperWrapper = objectMapperWrapper;
    }

    @Override
    public <T> T clone(T object) {
        Map map;
        Object firstElement;
        Collection collection;
        if (object instanceof Collection && !(collection = (Collection)object).isEmpty() && !((firstElement = collection.iterator().next()) instanceof Serializable)) {
            JavaType type = TypeFactory.defaultInstance().constructParametricType(collection.getClass(), new Class[]{firstElement.getClass()});
            return this.objectMapperWrapper.fromBytes(this.objectMapperWrapper.toBytes(collection), (Type)type);
        }
        if (object instanceof Map && !(map = (Map)object).isEmpty()) {
            firstElement = map.entrySet().iterator().next();
            Object key = firstElement.getKey();
            Object value = firstElement.getValue();
            if (!(key instanceof Serializable) || !(value instanceof Serializable)) {
                JavaType type = TypeFactory.defaultInstance().constructParametricType(map.getClass(), new Class[]{key.getClass(), value.getClass()});
                return this.objectMapperWrapper.fromBytes(this.objectMapperWrapper.toBytes(map), (Type)type);
            }
        }
        return (T)(object instanceof Serializable ? SerializationHelper.clone((Serializable)((Serializable)object)) : this.objectMapperWrapper.fromBytes(this.objectMapperWrapper.toBytes(object), object.getClass()));
    }
}

