/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.type.basic;

import com.vladmihalcea.hibernate.type.util.Configuration;
import com.vladmihalcea.hibernate.util.ReflectionUtils;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.EnumType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.spi.TypeBootstrapContext;

public class PostgreSQLEnumType
extends EnumType {
    public static final PostgreSQLEnumType INSTANCE = new PostgreSQLEnumType();
    private final Configuration configuration;

    public PostgreSQLEnumType() {
        this(Configuration.INSTANCE);
    }

    public PostgreSQLEnumType(Configuration configuration) {
        this.configuration = configuration;
    }

    public PostgreSQLEnumType(TypeBootstrapContext typeBootstrapContext) {
        this(new Configuration(typeBootstrapContext.getConfigurationSettings()));
    }

    public PostgreSQLEnumType(Class<? extends Enum> enumClass) {
        this();
        Class typeConfigurationClass = ReflectionUtils.getClassOrNull("org.hibernate.type.spi.TypeConfiguration");
        if (typeConfigurationClass != null) {
            Object typeConfiguration = ReflectionUtils.newInstance(typeConfigurationClass);
            Class enumJavaTypeDescriptorClass = ReflectionUtils.getClassOrNull("org.hibernate.type.descriptor.java.EnumJavaTypeDescriptor");
            Object enumJavaTypeDescriptor = ReflectionUtils.newInstance(enumJavaTypeDescriptorClass, new Object[]{enumClass}, new Class[]{enumClass.getClass()});
            Object javaTypeDescriptorRegistry = ReflectionUtils.invokeGetter(typeConfiguration, "javaTypeDescriptorRegistry");
            ReflectionUtils.invokeMethod(javaTypeDescriptorRegistry, ReflectionUtils.getMethod(javaTypeDescriptorRegistry, "addDescriptor", JavaTypeDescriptor.class), enumJavaTypeDescriptor);
            ReflectionUtils.invokeSetter((Object)this, "typeConfiguration", typeConfiguration);
        }
        Properties properties = new Properties();
        properties.setProperty("enumClass", enumClass.getName());
        properties.setProperty("useNamed", Boolean.TRUE.toString());
        this.setParameterValues(properties);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        st.setObject(index, (Object)(value != null ? ((Enum)value).name() : null), 1111);
    }
}

