/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.type.util;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.vladmihalcea.hibernate.type.util.JsonSerializer;
import com.vladmihalcea.hibernate.type.util.ObjectMapperWrapper;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import org.hibernate.internal.util.SerializationHelper;
import org.hibernate.type.SerializationException;

public class ObjectMapperJsonSerializer
implements JsonSerializer {
    private final ObjectMapperWrapper objectMapperWrapper;

    public ObjectMapperJsonSerializer(ObjectMapperWrapper objectMapperWrapper) {
        this.objectMapperWrapper = objectMapperWrapper;
    }

    @Override
    public <T> T clone(T object) {
        Map.Entry firstEntry;
        Object firstElement;
        if (object instanceof JsonNode) {
            return (T)((JsonNode)object).deepCopy();
        }
        if (object instanceof Collection && (firstElement = this.findFirstNonNullElement((Collection)object)) != null && !(firstElement instanceof Serializable)) {
            JavaType type = TypeFactory.defaultInstance().constructParametricType(object.getClass(), new Class[]{firstElement.getClass()});
            return this.objectMapperWrapper.fromBytes(this.objectMapperWrapper.toBytes(object), (Type)type);
        }
        if (object instanceof Map && (firstEntry = this.findFirstNonNullEntry((Map)object)) != null) {
            Object key = firstEntry.getKey();
            Object value = firstEntry.getValue();
            if (!(key instanceof Serializable) || !(value instanceof Serializable)) {
                JavaType type = TypeFactory.defaultInstance().constructParametricType(object.getClass(), new Class[]{key.getClass(), value.getClass()});
                return this.objectMapperWrapper.fromBytes(this.objectMapperWrapper.toBytes(object), (Type)type);
            }
        }
        if (object instanceof Serializable) {
            try {
                return (T)SerializationHelper.clone((Serializable)((Serializable)object));
            }
            catch (SerializationException e) {
                return this.jsonClone(object);
            }
        }
        return this.jsonClone(object);
    }

    private Object findFirstNonNullElement(Collection collection) {
        for (Object element : collection) {
            if (element == null) continue;
            return element;
        }
        return null;
    }

    private Map.Entry findFirstNonNullEntry(Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            return entry;
        }
        return null;
    }

    private <T> T jsonClone(T object) {
        return (T)this.objectMapperWrapper.fromBytes(this.objectMapperWrapper.toBytes(object), object.getClass());
    }
}

