/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.type.basic.internal;

import java.time.ZoneId;
import java.util.Comparator;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;

public class ZoneIdTypeDescriptor
extends AbstractClassJavaType<ZoneId> {
    public static final ZoneIdTypeDescriptor INSTANCE = new ZoneIdTypeDescriptor();

    public ZoneIdTypeDescriptor() {
        super(ZoneId.class);
    }

    public String toString(ZoneId value) {
        return value.getId();
    }

    public ZoneId fromString(String string) {
        return ZoneId.of(string);
    }

    public Comparator<ZoneId> getComparator() {
        return ZoneIdComparator.INSTANCE;
    }

    public <X> X unwrap(ZoneId value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)this.toString(value);
        }
        throw this.unknownUnwrap(type);
    }

    public <X> ZoneId wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (String.class.isInstance(value)) {
            return this.fromString((String)value);
        }
        throw this.unknownWrap(value.getClass());
    }

    public static class ZoneIdComparator
    implements Comparator<ZoneId> {
        public static final ZoneIdComparator INSTANCE = new ZoneIdComparator();

        @Override
        public int compare(ZoneId o1, ZoneId o2) {
            return o1.getId().compareTo(o2.getId());
        }
    }
}

