/*
 * Decompiled with CFR 0.152.
 */
package com.anarsoft.vmlens.concurrent.junit;

import com.anarsoft.vmlens.concurrent.junit.ThreadCount;
import com.anarsoft.vmlens.concurrent.junit.internal.ConcurrentStatement;
import com.anarsoft.vmlens.concurrent.junit.internal.InvokeListOfMethods;
import com.anarsoft.vmlens.concurrent.junit.internal.NoOpStatement;
import com.anarsoft.vmlens.concurrent.junit.internal.ParallelExecutorThread;
import com.anarsoft.vmlens.concurrent.junit.internal.TestResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.internal.runners.statements.Fail;
import org.junit.rules.MethodRule;
import org.junit.rules.RunRules;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentTestRunner
extends BlockJUnit4ClassRunner {
    private boolean alreadyRun = false;

    public ConcurrentTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected Statement childrenInvoker(final RunNotifier notifier) {
        return new Statement(){

            public void evaluate() {
                ConcurrentTestRunner.this.runChildrenConcurrently(notifier);
            }
        };
    }

    private void runChildrenConcurrently(RunNotifier notifier) {
        Object test;
        if (this.alreadyRun) {
            return;
        }
        this.alreadyRun = true;
        LinkedList<EachTestNotifier> eachTestNotifierList = new LinkedList<EachTestNotifier>();
        LinkedList<ConcurrentStatement> concurrentStatementList = new LinkedList<ConcurrentStatement>();
        try {
            test = new ReflectiveCallable(){

                protected Object runReflectiveCall() throws Throwable {
                    return ConcurrentTestRunner.this.createTest();
                }
            }.run();
        }
        catch (Throwable e) {
            for (FrameworkMethod method : this.getChildren()) {
                Description description = this.describeChild(method);
                notifier.fireTestFailure(new Failure(description, e));
            }
            return;
        }
        for (FrameworkMethod method : this.getChildren()) {
            Description description = this.describeChild(method);
            if (this.callIsIgnoredWithReflection(method)) {
                notifier.fireTestIgnored(description);
                continue;
            }
            EachTestNotifier eachTestNotifier = new EachTestNotifier(notifier, description);
            eachTestNotifier.fireTestStarted();
            eachTestNotifierList.add(eachTestNotifier);
            Statement statement = this.createMethodStatement(method, test);
            ThreadCount threadCountAnnotation = (ThreadCount)method.getAnnotation(ThreadCount.class);
            int threadCount = 4;
            if (threadCountAnnotation != null) {
                threadCount = threadCountAnnotation.value();
            }
            for (int i = 0; i < threadCount; ++i) {
                concurrentStatementList.add(new ConcurrentStatement(statement, eachTestNotifier));
            }
        }
        Statement before = this.createBefores(test);
        this.evaluateStatement(before, eachTestNotifierList);
        LinkedList<ParallelExecutorThread> threadList = new LinkedList<ParallelExecutorThread>();
        for (ConcurrentStatement concurrentStatement : concurrentStatementList) {
            ParallelExecutorThread parallelExecutorThread = new ParallelExecutorThread(concurrentStatement);
            threadList.add(parallelExecutorThread);
            parallelExecutorThread.start();
        }
        int stillRunningThreads = 0;
        for (ParallelExecutorThread parallelExecutorThread : threadList) {
            try {
                parallelExecutorThread.join(150000L);
                if (!parallelExecutorThread.isAlive()) continue;
                ++stillRunningThreads;
                parallelExecutorThread.interrupt();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (stillRunningThreads > 0) {
            System.err.println("still running threads: " + stillRunningThreads);
        } else {
            for (ConcurrentStatement concurrentStatement : concurrentStatementList) {
                concurrentStatement.addFailures();
            }
            Statement statement = this.createAfters(test);
            this.evaluateStatement(statement, eachTestNotifierList);
        }
        for (EachTestNotifier eachTestNotifier : eachTestNotifierList) {
            eachTestNotifier.fireTestFinished();
        }
    }

    private boolean callIsIgnoredWithReflection(FrameworkMethod method) {
        Method m;
        try {
            m = BlockJUnit4ClassRunner.class.getDeclaredMethod("isIgnored", FrameworkMethod.class);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
        try {
            return (Boolean)m.invoke((Object)this, method);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return false;
    }

    private void evaluateStatement(Statement statement, List<EachTestNotifier> eachTestNotifierList) {
        TestResult testResult = ConcurrentStatement.evaluateStatement(statement);
        for (EachTestNotifier eachTestNotifier : eachTestNotifierList) {
            testResult.addFailure(eachTestNotifier);
        }
    }

    private List<MethodRule> getMethodRules(Object target) {
        return this.rules(target);
    }

    private Statement withTestRules(FrameworkMethod method, List<TestRule> testRules, Statement statement) {
        return testRules.isEmpty() ? statement : new RunRules(statement, testRules, this.describeChild(method));
    }

    private Statement withRules(FrameworkMethod method, Object target, Statement statement) {
        List testRules = this.getTestRules(target);
        Statement result = statement;
        result = this.withMethodRules(method, testRules, target, result);
        result = this.withTestRules(method, testRules, result);
        return result;
    }

    private Statement withMethodRules(FrameworkMethod method, List<TestRule> testRules, Object target, Statement result) {
        for (MethodRule each : this.getMethodRules(target)) {
            if (testRules.contains(each)) continue;
            result = each.apply(result, method, target);
        }
        return result;
    }

    protected Statement createMethodStatement(FrameworkMethod method, Object test) {
        Statement statement;
        try {
            statement = this.methodInvoker(method, test);
            statement = this.possiblyExpectingExceptions(method, test, statement);
            statement = this.withRules(method, test, statement);
        }
        catch (Throwable ex) {
            statement = new Fail(ex);
        }
        return statement;
    }

    protected Statement createBefores(Object target) {
        List befores = this.getTestClass().getAnnotatedMethods(Before.class);
        return befores.isEmpty() ? new NoOpStatement() : new InvokeListOfMethods(befores, target);
    }

    protected Statement createAfters(Object target) {
        List afters = this.getTestClass().getAnnotatedMethods(After.class);
        return afters.isEmpty() ? new NoOpStatement() : new InvokeListOfMethods(afters, target);
    }
}

