/*
 * Decompiled with CFR 0.152.
 */
package com.wdullaer.materialdatetimepicker.time;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

public class Timepoint
implements Parcelable,
Comparable<Timepoint> {
    private int hour;
    private int minute;
    private int second;
    public static final Parcelable.Creator<Timepoint> CREATOR = new Parcelable.Creator<Timepoint>(){

        public Timepoint createFromParcel(Parcel in) {
            return new Timepoint(in);
        }

        public Timepoint[] newArray(int size) {
            return new Timepoint[size];
        }
    };

    public Timepoint(Timepoint time) {
        this(time.hour, time.minute, time.second);
    }

    public Timepoint(@IntRange(from=0L, to=23L) int hour, @IntRange(from=0L, to=59L) int minute, @IntRange(from=0L, to=59L) int second) {
        this.hour = hour % 24;
        this.minute = minute % 60;
        this.second = second % 60;
    }

    public Timepoint(@IntRange(from=0L, to=23L) int hour, @IntRange(from=0L, to=59L) int minute) {
        this(hour, minute, 0);
    }

    public Timepoint(@IntRange(from=0L, to=23L) int hour) {
        this(hour, 0);
    }

    public Timepoint(Parcel in) {
        this.hour = in.readInt();
        this.minute = in.readInt();
        this.second = in.readInt();
    }

    @IntRange(from=0L, to=23L)
    public int getHour() {
        return this.hour;
    }

    @IntRange(from=0L, to=59L)
    public int getMinute() {
        return this.minute;
    }

    @IntRange(from=0L, to=59L)
    public int getSecond() {
        return this.second;
    }

    public boolean isAM() {
        return this.hour < 12;
    }

    public boolean isPM() {
        return !this.isAM();
    }

    public void setAM() {
        if (this.hour >= 12) {
            this.hour %= 12;
        }
    }

    public void setPM() {
        if (this.hour < 12) {
            this.hour = (this.hour + 12) % 24;
        }
    }

    public void add(TYPE type, int value) {
        if (type == TYPE.MINUTE) {
            value *= 60;
        }
        if (type == TYPE.HOUR) {
            value *= 3600;
        }
        value += this.toSeconds();
        switch (type) {
            case SECOND: {
                this.second = value % 3600 % 60;
            }
            case MINUTE: {
                this.minute = value % 3600 / 60;
            }
            case HOUR: {
                this.hour = value / 3600 % 24;
            }
        }
    }

    public int get(@NonNull TYPE type) {
        switch (type) {
            case SECOND: {
                return this.getSecond();
            }
            case MINUTE: {
                return this.getMinute();
            }
        }
        return this.getHour();
    }

    public int toSeconds() {
        return 3600 * this.hour + 60 * this.minute + this.second;
    }

    public int hashCode() {
        return this.toSeconds();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Timepoint timepoint = (Timepoint)o;
        return this.hashCode() == timepoint.hashCode();
    }

    public boolean equals(@Nullable Timepoint time, @NonNull TYPE resolution) {
        if (time == null) {
            return false;
        }
        boolean output = true;
        switch (resolution) {
            case SECOND: {
                output = output && time.getSecond() == this.getSecond();
            }
            case MINUTE: {
                output = output && time.getMinute() == this.getMinute();
            }
            case HOUR: {
                output = output && time.getHour() == this.getHour();
            }
        }
        return output;
    }

    @Override
    public int compareTo(@NonNull Timepoint t) {
        return this.hashCode() - t.hashCode();
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.hour);
        out.writeInt(this.minute);
        out.writeInt(this.second);
    }

    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "" + this.hour + "h " + this.minute + "m " + this.second + "s";
    }

    public static enum TYPE {
        HOUR,
        MINUTE,
        SECOND;

    }
}

