/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import com.webauthn4j.data.extension.authenticator.RegistrationExtensionAuthenticatorOutput;
import java.io.Serializable;
import java.util.Objects;

public class AttestationObject
implements Serializable {
    @JsonProperty(value="authData")
    private final AuthenticatorData<RegistrationExtensionAuthenticatorOutput<?>> authenticatorData;
    @JsonProperty(value="attStmt")
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXTERNAL_PROPERTY, property="fmt")
    private final AttestationStatement attestationStatement;

    @JsonCreator
    public AttestationObject(@JsonProperty(value="authData") AuthenticatorData<RegistrationExtensionAuthenticatorOutput<?>> authenticatorData, @JsonProperty(value="attStmt") AttestationStatement attestationStatement) {
        this.authenticatorData = authenticatorData;
        this.attestationStatement = attestationStatement;
    }

    public AuthenticatorData<RegistrationExtensionAuthenticatorOutput<?>> getAuthenticatorData() {
        return this.authenticatorData;
    }

    @JsonProperty(value="fmt")
    public String getFormat() {
        return this.attestationStatement.getFormat();
    }

    public AttestationStatement getAttestationStatement() {
        return this.attestationStatement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttestationObject that = (AttestationObject)o;
        return Objects.equals(this.authenticatorData, that.authenticatorData) && Objects.equals(this.attestationStatement, that.attestationStatement);
    }

    public int hashCode() {
        return Objects.hash(this.authenticatorData, this.attestationStatement);
    }
}

