/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swagger.jaxrs;

import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.converter.ModelConverters;
import com.wordnik.swagger.models.ArrayModel;
import com.wordnik.swagger.models.Model;
import com.wordnik.swagger.models.ModelImpl;
import com.wordnik.swagger.models.RefModel;
import com.wordnik.swagger.models.Swagger;
import com.wordnik.swagger.models.parameters.BodyParameter;
import com.wordnik.swagger.models.parameters.CookieParameter;
import com.wordnik.swagger.models.parameters.HeaderParameter;
import com.wordnik.swagger.models.parameters.Parameter;
import com.wordnik.swagger.models.parameters.PathParameter;
import com.wordnik.swagger.models.parameters.QueryParameter;
import com.wordnik.swagger.models.parameters.SerializableParameter;
import com.wordnik.swagger.models.properties.Property;
import com.wordnik.swagger.models.properties.PropertyBuilder;
import com.wordnik.swagger.models.properties.RefProperty;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterProcessor {
    static Logger LOGGER = LoggerFactory.getLogger(ParameterProcessor.class);

    public static Parameter applyAnnotations(Swagger swagger, Parameter parameter, Class<?> cls, Annotation[] annotations, boolean isArray) {
        String defaultValue = null;
        boolean shouldIgnore = false;
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof ApiParam)) continue;
            ApiParam param = (ApiParam)annotation;
            if (parameter != null) {
                Property items;
                PathParameter p;
                boolean allowMultiple;
                if (!param.defaultValue().isEmpty()) {
                    defaultValue = param.defaultValue();
                }
                if (param.required()) {
                    parameter.setRequired(param.required());
                }
                if (param.name() != null && !"".equals(param.name())) {
                    parameter.setName(param.name());
                }
                parameter.setDescription(param.value());
                parameter.setAccess(param.access());
                boolean bl = allowMultiple = param.allowMultiple() || isArray;
                if (parameter instanceof PathParameter) {
                    p = (PathParameter)parameter;
                    if (defaultValue != null) {
                        p.setDefaultValue(defaultValue);
                    }
                    if (allowMultiple) {
                        items = PropertyBuilder.build((String)p.getType(), (String)p.getFormat(), null);
                        p.items(items).array(true).collectionFormat("multi");
                    }
                } else if (parameter instanceof QueryParameter) {
                    p = (QueryParameter)parameter;
                    if (defaultValue != null) {
                        p.setDefaultValue(defaultValue);
                    }
                    if (allowMultiple) {
                        items = PropertyBuilder.build((String)p.getType(), (String)p.getFormat(), null);
                        p.items(items).array(true).collectionFormat("multi");
                    }
                } else if (parameter instanceof HeaderParameter) {
                    p = (HeaderParameter)parameter;
                    if (defaultValue != null) {
                        p.setDefaultValue(defaultValue);
                    }
                    if (allowMultiple) {
                        items = PropertyBuilder.build((String)p.getType(), (String)p.getFormat(), null);
                        p.items(items).array(true).collectionFormat("multi");
                    }
                } else if (parameter instanceof CookieParameter) {
                    p = (CookieParameter)parameter;
                    if (defaultValue != null) {
                        p.setDefaultValue(defaultValue);
                    }
                    if (allowMultiple) {
                        items = PropertyBuilder.build((String)p.getType(), (String)p.getFormat(), null);
                        p.items(items).array(true).collectionFormat("multi");
                    }
                }
                String allowableValues = param.allowableValues();
                if (allowableValues == null || allowableValues.startsWith("range")) continue;
                String[] values = allowableValues.split(",");
                ArrayList<String> _enum = new ArrayList<String>();
                for (String value : values) {
                    String trimmed = value.trim();
                    if (trimmed.equals("")) continue;
                    _enum.add(trimmed);
                }
                if (!(parameter instanceof SerializableParameter)) continue;
                SerializableParameter p2 = (SerializableParameter)parameter;
                if (_enum.size() <= 0) continue;
                p2.setEnum(_enum);
                continue;
            }
            if (shouldIgnore) continue;
            BodyParameter bp = new BodyParameter();
            if (param.name() != null && !"".equals(param.name())) {
                bp.setName(param.name());
            } else {
                bp.setName("body");
            }
            bp.setDescription(param.value());
            if (cls.isArray() || isArray) {
                Class<?> innerType = isArray ? cls : cls.getComponentType();
                LOGGER.debug("inner type: " + innerType + " from " + cls);
                Property innerProperty = ModelConverters.getInstance().readAsProperty(innerType);
                if (innerProperty == null) {
                    Map models = ModelConverters.getInstance().read(innerType);
                    if (models.size() > 0) {
                        for (String name : models.keySet()) {
                            if (name.indexOf("java.util") != -1) continue;
                            bp.setSchema((Model)new ArrayModel().items((Property)new RefProperty().asDefault(name)));
                            if (swagger == null) continue;
                            swagger.addDefinition(name, (Model)models.get(name));
                        }
                    }
                    models = ModelConverters.getInstance().readAll(innerType);
                    if (swagger != null) {
                        for (String key : models.keySet()) {
                            swagger.model(key, (Model)models.get(key));
                        }
                    }
                } else {
                    LOGGER.debug("found inner property " + innerProperty);
                    bp.setSchema((Model)new ArrayModel().items(innerProperty));
                    if (innerProperty instanceof RefProperty && swagger != null) {
                        Map models = ModelConverters.getInstance().read(innerType);
                        String name = ((RefProperty)innerProperty).getSimpleRef();
                        swagger.addDefinition(name, (Model)models.get(name));
                        LOGGER.debug("added model definition for RefProperty " + name);
                    }
                }
            } else {
                Map models = ModelConverters.getInstance().read(cls);
                if (models.size() > 0) {
                    for (String name : models.keySet()) {
                        if (name.indexOf("java.util") != -1) continue;
                        if (isArray) {
                            bp.setSchema((Model)new ArrayModel().items((Property)new RefProperty().asDefault(name)));
                        } else {
                            bp.setSchema((Model)new RefModel().asDefault(name));
                        }
                        if (swagger == null) continue;
                        swagger.addDefinition(name, (Model)models.get(name));
                    }
                    models = ModelConverters.getInstance().readAll(cls);
                    if (swagger != null) {
                        for (String key : models.keySet()) {
                            swagger.model(key, (Model)models.get(key));
                        }
                    }
                } else {
                    Property prop = ModelConverters.getInstance().readAsProperty(cls);
                    if (prop != null) {
                        ModelImpl model = new ModelImpl();
                        model.setType(prop.getType());
                        bp.setSchema((Model)model);
                    }
                }
            }
            parameter = bp;
        }
        return parameter;
    }
}

