/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swagger.jaxrs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import com.wordnik.swagger.annotations.Authorization;
import com.wordnik.swagger.annotations.AuthorizationScope;
import com.wordnik.swagger.annotations.ResponseHeader;
import com.wordnik.swagger.converter.ModelConverters;
import com.wordnik.swagger.jaxrs.PATCH;
import com.wordnik.swagger.jaxrs.ParameterProcessor;
import com.wordnik.swagger.jaxrs.ext.SwaggerExtension;
import com.wordnik.swagger.jaxrs.ext.SwaggerExtensions;
import com.wordnik.swagger.jaxrs.utils.ParameterUtils;
import com.wordnik.swagger.models.Model;
import com.wordnik.swagger.models.Operation;
import com.wordnik.swagger.models.Path;
import com.wordnik.swagger.models.Response;
import com.wordnik.swagger.models.Scheme;
import com.wordnik.swagger.models.SecurityDefinition;
import com.wordnik.swagger.models.SecurityRequirement;
import com.wordnik.swagger.models.Swagger;
import com.wordnik.swagger.models.Tag;
import com.wordnik.swagger.models.parameters.Parameter;
import com.wordnik.swagger.models.properties.ArrayProperty;
import com.wordnik.swagger.models.properties.MapProperty;
import com.wordnik.swagger.models.properties.Property;
import com.wordnik.swagger.models.properties.RefProperty;
import com.wordnik.swagger.util.Json;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reader {
    Logger LOGGER = LoggerFactory.getLogger(Reader.class);
    Swagger swagger;
    static ObjectMapper m = Json.mapper();

    public Reader(Swagger swagger) {
        this.swagger = swagger;
    }

    public Swagger read(Set<Class<?>> classes) {
        for (Class<?> cls : classes) {
            this.read(cls);
        }
        return this.swagger;
    }

    public Swagger getSwagger() {
        return this.swagger;
    }

    public Swagger read(Class cls) {
        return this.read(cls, "", null, false, new String[0], new String[0], new HashMap<String, Tag>(), new ArrayList<Parameter>());
    }

    protected Swagger read(Class<?> cls, String parentPath, String parentMethod, boolean readHidden, String[] parentConsumes, String[] parentProduces, Map<String, Tag> parentTags, List<Parameter> parentParameters) {
        if (this.swagger == null) {
            this.swagger = new Swagger();
        }
        Api api = cls.getAnnotation(Api.class);
        HashMap globalScopes = new HashMap();
        javax.ws.rs.Path apiPath = cls.getAnnotation(javax.ws.rs.Path.class);
        String[] apiConsumes = new String[]{};
        String[] apiProduces = new String[]{};
        if (api != null && readHidden || api != null && !api.hidden()) {
            Method[] methods;
            Set<String> tagStrings = this.extractTags(api);
            HashMap<String, Tag> tags = new HashMap<String, Tag>();
            for (String tagString : tagStrings) {
                Tag tag = new Tag().name(tagString);
                tags.put(tagString, tag);
            }
            if (parentTags != null) {
                tags.putAll(parentTags);
            }
            for (String tagName : tags.keySet()) {
                this.swagger.tag((Tag)tags.get(tagName));
            }
            int position = api.position();
            String produces = api.produces();
            String consumes = api.consumes();
            String schems = api.protocols();
            Authorization[] authorizations = api.authorizations();
            ArrayList<SecurityRequirement> securities = new ArrayList<SecurityRequirement>();
            for (Authorization auth : authorizations) {
                AuthorizationScope[] scopes;
                if (auth.value() == null || "".equals(auth.value())) continue;
                SecurityRequirement security = new SecurityRequirement();
                security.setName(auth.value());
                for (AuthorizationScope scope : scopes = auth.scopes()) {
                    if (scope.scope() == null || "".equals(scope.scope())) continue;
                    security.addScope(scope.scope());
                }
                securities.add(security);
            }
            for (Method method : methods = cls.getMethods()) {
                HashSet<String> both;
                Consumes annotation;
                ApiOperation apiOperation = method.getAnnotation(ApiOperation.class);
                javax.ws.rs.Path methodPath = method.getAnnotation(javax.ws.rs.Path.class);
                String operationPath = this.getPath(apiPath, methodPath, parentPath);
                if (operationPath == null || apiOperation == null) continue;
                String[] pps = operationPath.split("/");
                String[] pathParts = new String[pps.length];
                HashMap<String, String> regexMap = new HashMap<String, String>();
                for (int i = 0; i < pps.length; ++i) {
                    String p = pps[i];
                    if (p.startsWith("{")) {
                        int pos = p.indexOf(":");
                        if (pos > 0) {
                            String left = p.substring(1, pos);
                            String right = p.substring(pos + 1, p.length() - 1);
                            pathParts[i] = "{" + left + "}";
                            regexMap.put(left, right);
                            continue;
                        }
                        pathParts[i] = p;
                        continue;
                    }
                    pathParts[i] = p;
                }
                StringBuilder pathBuilder = new StringBuilder();
                for (String p : pathParts) {
                    if (p.isEmpty()) continue;
                    pathBuilder.append("/").append(p);
                }
                operationPath = pathBuilder.toString();
                String httpMethod = this.extractOperationMethod(apiOperation, method, SwaggerExtensions.chain());
                Operation operation = this.parseMethod(method);
                if (parentParameters != null) {
                    for (Parameter param : parentParameters) {
                        operation.parameter(param);
                    }
                }
                for (Parameter param : operation.getParameters()) {
                    if (regexMap.get(param.getName()) == null) continue;
                    String pattern = (String)regexMap.get(param.getName());
                    param.setPattern(pattern);
                }
                String protocols = apiOperation.protocols();
                if (!"".equals(protocols)) {
                    String[] parts;
                    for (String part : parts = protocols.split(",")) {
                        String trimmed = part.trim();
                        if ("".equals(trimmed)) continue;
                        operation.scheme(Scheme.forValue((String)trimmed));
                    }
                }
                if ((annotation = cls.getAnnotation(Consumes.class)) != null) {
                    apiConsumes = annotation.value();
                }
                if (parentConsumes != null) {
                    both = new HashSet<String>(Arrays.asList(apiConsumes));
                    both.addAll(new HashSet<String>(Arrays.asList(parentConsumes)));
                    if (operation.getConsumes() != null) {
                        both.addAll(new HashSet(operation.getConsumes()));
                    }
                    apiConsumes = both.toArray(new String[both.size()]);
                }
                if ((annotation = cls.getAnnotation(Produces.class)) != null) {
                    apiProduces = ((Produces)annotation).value();
                }
                if (parentProduces != null) {
                    both = new HashSet<String>(Arrays.asList(apiProduces));
                    both.addAll(new HashSet<String>(Arrays.asList(parentProduces)));
                    if (operation.getProduces() != null) {
                        both.addAll(new HashSet(operation.getProduces()));
                    }
                    apiProduces = both.toArray(new String[both.size()]);
                }
                if (this.isSubResource(method)) {
                    Type t = method.getGenericReturnType();
                    Class<?> responseClass = method.getReturnType();
                    Swagger subSwagger = this.read(responseClass, operationPath, httpMethod, true, apiConsumes, apiProduces, tags, operation.getParameters());
                }
                String string = httpMethod = httpMethod == null ? parentMethod : httpMethod;
                if (httpMethod == null) continue;
                ApiOperation op = method.getAnnotation(ApiOperation.class);
                if (op != null) {
                    boolean hasExplicitTag = false;
                    for (String tag : op.tags()) {
                        if ("".equals(tag)) continue;
                        operation.tag(tag);
                        this.swagger.tag(new Tag().name(tag));
                    }
                }
                if (operation == null) continue;
                if (operation.getConsumes() == null) {
                    for (String mediaType : apiConsumes) {
                        operation.consumes(mediaType);
                    }
                }
                if (operation.getProduces() == null) {
                    for (String mediaType : apiProduces) {
                        operation.produces(mediaType);
                    }
                }
                if (operation.getTags() == null) {
                    for (String tagString : tags.keySet()) {
                        operation.tag(tagString);
                    }
                }
                for (SecurityRequirement security : securities) {
                    operation.security(security);
                }
                Path path = this.swagger.getPath(operationPath);
                if (path == null) {
                    path = new Path();
                    this.swagger.path(operationPath, path);
                }
                path.set(httpMethod, operation);
            }
        }
        return this.swagger;
    }

    protected boolean isSubResource(Method method) {
        Type t = method.getGenericReturnType();
        Class<?> responseClass = method.getReturnType();
        return responseClass != null && responseClass.getAnnotation(Api.class) != null;
    }

    protected Set<String> extractTags(Api api) {
        String tagString;
        LinkedHashSet<String> output = new LinkedHashSet<String>();
        boolean hasExplicitTags = false;
        for (String tag : api.tags()) {
            if ("".equals(tag)) continue;
            hasExplicitTags = true;
            output.add(tag);
        }
        if (!hasExplicitTags && !"".equals(tagString = api.value().replace("/", ""))) {
            output.add(tagString);
        }
        return output;
    }

    String getPath(javax.ws.rs.Path classLevelPath, javax.ws.rs.Path methodLevelPath, String parentPath) {
        String output;
        if (classLevelPath == null && methodLevelPath == null) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        if (parentPath != null && !"".equals(parentPath) && !"/".equals(parentPath)) {
            if (!parentPath.startsWith("/")) {
                parentPath = "/" + parentPath;
            }
            if (parentPath.endsWith("/")) {
                parentPath = parentPath.substring(0, parentPath.length() - 1);
            }
            b.append(parentPath);
        }
        if (classLevelPath != null) {
            b.append(classLevelPath.value());
        }
        if (methodLevelPath != null && !"/".equals(methodLevelPath.value())) {
            String methodPath = methodLevelPath.value();
            if (!methodPath.startsWith("/") && !b.toString().endsWith("/")) {
                b.append("/");
            }
            if (methodPath.endsWith("/")) {
                methodPath = methodPath.substring(0, methodPath.length() - 1);
            }
            b.append(methodPath);
        }
        if (!(output = b.toString()).startsWith("/")) {
            output = "/" + output;
        }
        if (output.endsWith("/") && output.length() > 1) {
            return output.substring(0, output.length() - 1);
        }
        return output;
    }

    public Map<String, Property> parseResponseHeaders(ResponseHeader[] headers) {
        HashMap<String, ArrayProperty> responseHeaders = null;
        if (headers != null && headers.length > 0) {
            for (ResponseHeader header : headers) {
                String name = header.name();
                if ("".equals(name)) continue;
                if (responseHeaders == null) {
                    responseHeaders = new HashMap<String, ArrayProperty>();
                }
                String description = header.description();
                Class cls = header.response();
                String container = header.responseContainer();
                if (cls.equals(Void.class) || "void".equals(cls.toString())) continue;
                Object responseProperty = null;
                Property property = ModelConverters.getInstance().readAsProperty((Type)cls);
                if (property == null) continue;
                responseProperty = "list".equalsIgnoreCase(container) ? new ArrayProperty(property) : ("map".equalsIgnoreCase(container) ? new MapProperty(property) : property);
                responseProperty.setDescription(description);
                responseHeaders.put(name, (ArrayProperty)responseProperty);
            }
        }
        return responseHeaders;
    }

    public Operation parseMethod(Method method) {
        Operation operation = new Operation();
        ApiOperation apiOperation = method.getAnnotation(ApiOperation.class);
        ApiResponses responseAnnotation = method.getAnnotation(ApiResponses.class);
        String operationId = method.getName();
        String responseContainer = null;
        Class responseClass = null;
        Map<Object, Object> defaultResponseHeaders = new HashMap();
        if (apiOperation != null) {
            if (apiOperation.hidden()) {
                return null;
            }
            if (!"".equals(apiOperation.nickname())) {
                operationId = method.getName();
            }
            defaultResponseHeaders = this.parseResponseHeaders(apiOperation.responseHeaders());
            operation.summary(apiOperation.value()).description(apiOperation.notes());
            if (apiOperation.response() != null && !Void.class.equals((Object)apiOperation.response())) {
                responseClass = apiOperation.response();
            }
            if (!"".equals(apiOperation.responseContainer())) {
                responseContainer = apiOperation.responseContainer();
            }
            if (apiOperation.authorizations() != null) {
                ArrayList<SecurityRequirement> securities = new ArrayList<SecurityRequirement>();
                for (Authorization auth : apiOperation.authorizations()) {
                    AuthorizationScope[] scopes;
                    if (auth.value() == null || "".equals(auth.value())) continue;
                    SecurityRequirement security = new SecurityRequirement();
                    security.setName(auth.value());
                    for (AuthorizationScope scope : scopes = auth.scopes()) {
                        SecurityDefinition definition = new SecurityDefinition(auth.type());
                        if (scope.scope() == null || "".equals(scope.scope())) continue;
                        security.addScope(scope.scope());
                        definition.scope(scope.scope(), scope.description());
                    }
                    securities.add(security);
                }
                if (securities.size() > 0) {
                    for (SecurityRequirement sec : securities) {
                        operation.security(sec);
                    }
                }
            }
        }
        if (responseClass == null) {
            this.LOGGER.debug("picking up response class from method " + method);
            Type t = method.getGenericReturnType();
            responseClass = method.getReturnType();
            if (!responseClass.equals(Void.class) && !"void".equals(responseClass.toString()) && responseClass.getAnnotation(Api.class) == null) {
                this.LOGGER.debug("reading model " + responseClass);
                Map models = ModelConverters.getInstance().readAll(t);
            }
        }
        if (responseClass != null && !responseClass.equals(Void.class) && !responseClass.equals(javax.ws.rs.core.Response.class) && responseClass.getAnnotation(Api.class) == null) {
            if (this.isPrimitive(responseClass)) {
                Object responseProperty = null;
                Property property = ModelConverters.getInstance().readAsProperty(responseClass);
                if (property != null) {
                    responseProperty = "list".equalsIgnoreCase(responseContainer) ? new ArrayProperty(property) : ("map".equalsIgnoreCase(responseContainer) ? new MapProperty(property) : property);
                    operation.response(200, new Response().description("successful operation").schema((Property)responseProperty).headers(defaultResponseHeaders));
                }
            } else if (!responseClass.equals(Void.class) && !"void".equals(responseClass.toString())) {
                Map models = ModelConverters.getInstance().read((Type)responseClass);
                if (models.size() == 0) {
                    Property p = ModelConverters.getInstance().readAsProperty((Type)responseClass);
                    operation.response(200, new Response().description("successful operation").schema(p).headers(defaultResponseHeaders));
                }
                for (String key : models.keySet()) {
                    Object responseProperty = null;
                    responseProperty = "list".equalsIgnoreCase(responseContainer) ? new ArrayProperty((Property)new RefProperty().asDefault(key)) : ("map".equalsIgnoreCase(responseContainer) ? new MapProperty((Property)new RefProperty().asDefault(key)) : new RefProperty().asDefault(key));
                    operation.response(200, new Response().description("successful operation").schema((Property)responseProperty).headers(defaultResponseHeaders));
                    this.swagger.model(key, (Model)models.get(key));
                }
                models = ModelConverters.getInstance().readAll((Type)responseClass);
                for (String key : models.keySet()) {
                    this.swagger.model(key, (Model)models.get(key));
                }
            }
        }
        operation.operationId(operationId);
        Object annotation = method.getAnnotation(Consumes.class);
        if (annotation != null) {
            String[] apiConsumes;
            for (String mediaType : apiConsumes = annotation.value()) {
                operation.consumes(mediaType);
            }
        }
        if ((annotation = method.getAnnotation(Produces.class)) != null) {
            String[] apiProduces;
            for (String mediaType : apiProduces = ((Produces)annotation).value()) {
                operation.produces(mediaType);
            }
        }
        ArrayList apiResponses = new ArrayList();
        if (responseAnnotation != null) {
            for (ApiResponse apiResponse : responseAnnotation.value()) {
                Map<String, Property> responseHeaders = this.parseResponseHeaders(apiResponse.responseHeaders());
                Response response = new Response().description(apiResponse.message()).headers(responseHeaders);
                if (apiResponse.code() == 0) {
                    operation.defaultResponse(response);
                } else {
                    operation.response(apiResponse.code(), response);
                }
                responseClass = apiResponse.response();
                if (responseClass == null || responseClass.equals(Void.class)) continue;
                Map models = ModelConverters.getInstance().read((Type)responseClass);
                for (String key : models.keySet()) {
                    response.schema((Property)new RefProperty().asDefault(key));
                    this.swagger.model(key, (Model)models.get(key));
                }
                models = ModelConverters.getInstance().readAll((Type)responseClass);
                for (String key : models.keySet()) {
                    this.swagger.model(key, (Model)models.get(key));
                }
            }
        }
        boolean isDeprecated = false;
        annotation = method.getAnnotation(Deprecated.class);
        if (annotation != null) {
            isDeprecated = true;
        }
        boolean hidden = false;
        if (apiOperation != null) {
            hidden = apiOperation.hidden();
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> cls = parameterTypes[i];
            Type type = genericParameterTypes[i];
            List<Parameter> parameters = this.getParameters(cls, type, paramAnnotations[i]);
            for (Parameter parameter : parameters) {
                operation.parameter(parameter);
            }
        }
        if (operation.getResponses() == null) {
            operation.defaultResponse(new Response().description("successful operation"));
        }
        return operation;
    }

    List<Parameter> getParameters(Class<?> cls, Type type, Annotation[] annotations) {
        boolean isArray = ParameterUtils.isMethodArgumentAnArray(cls, type);
        Iterator<SwaggerExtension> chain = SwaggerExtensions.chain();
        List<Parameter> parameters = null;
        this.LOGGER.debug("getParameters for " + cls);
        HashSet classesToSkip = new HashSet();
        if (chain.hasNext()) {
            SwaggerExtension extension = chain.next();
            this.LOGGER.debug("trying extension " + extension);
            parameters = extension.extractParameters(annotations, cls, isArray, classesToSkip, chain);
        }
        if (parameters.size() > 0) {
            for (Parameter parameter : parameters) {
                ParameterProcessor.applyAnnotations(this.swagger, parameter, cls, annotations, isArray);
            }
        } else {
            this.LOGGER.debug("no parameter found, looking at body params");
            if (!classesToSkip.contains(cls)) {
                if (type instanceof ParameterizedType) {
                    Parameter param;
                    ParameterizedType ti = (ParameterizedType)type;
                    Type innerType = ti.getActualTypeArguments()[0];
                    if (innerType instanceof Class && (param = ParameterProcessor.applyAnnotations(this.swagger, null, (Class)innerType, annotations, isArray)) != null) {
                        parameters.add(param);
                    }
                } else {
                    Parameter param = ParameterProcessor.applyAnnotations(this.swagger, null, cls, annotations, isArray);
                    if (param != null) {
                        parameters.add(param);
                    }
                }
            }
        }
        return parameters;
    }

    public String extractOperationMethod(ApiOperation apiOperation, Method method, Iterator<SwaggerExtension> chain) {
        if (apiOperation.httpMethod() != null && !"".equals(apiOperation.httpMethod())) {
            return apiOperation.httpMethod().toLowerCase();
        }
        if (method.getAnnotation(GET.class) != null) {
            return "get";
        }
        if (method.getAnnotation(PUT.class) != null) {
            return "put";
        }
        if (method.getAnnotation(POST.class) != null) {
            return "post";
        }
        if (method.getAnnotation(DELETE.class) != null) {
            return "delete";
        }
        if (method.getAnnotation(OPTIONS.class) != null) {
            return "options";
        }
        if (method.getAnnotation(HEAD.class) != null) {
            return "head";
        }
        if (method.getAnnotation(PATCH.class) != null) {
            return "patch";
        }
        if (method.getAnnotation(HttpMethod.class) != null) {
            HttpMethod httpMethod = method.getAnnotation(HttpMethod.class);
            return httpMethod.value().toLowerCase();
        }
        if (chain.hasNext()) {
            return chain.next().extractOperationMethod(apiOperation, method, chain);
        }
        return null;
    }

    boolean isPrimitive(Class<?> cls) {
        boolean out = false;
        Property property = ModelConverters.getInstance().readAsProperty(cls);
        if (property == null) {
            out = false;
        } else if ("integer".equals(property.getType())) {
            out = true;
        } else if ("string".equals(property.getType())) {
            out = true;
        } else if ("number".equals(property.getType())) {
            out = true;
        } else if ("boolean".equals(property.getType())) {
            out = true;
        } else if ("array".equals(property.getType())) {
            out = true;
        } else if ("file".equals(property.getType())) {
            out = true;
        }
        return out;
    }
}

