/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swagger.jaxrs.listing;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.wordnik.swagger.models.Swagger;
import com.wordnik.swagger.util.Json;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Produces(value={"application/json", "application/xml", "application/yaml"})
public class SwaggerSerializers
implements MessageBodyWriter<Swagger> {
    Logger LOGGER = LoggerFactory.getLogger(SwaggerSerializers.class);
    static ObjectMapper yaml;
    static boolean prettyPrint;

    public static void setPrettyPrint(boolean shouldPrettyPrint) {
        prettyPrint = shouldPrettyPrint;
    }

    public boolean isWriteable(Class type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Swagger.class.isAssignableFrom(type);
    }

    public long getSize(Swagger data, Class type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Swagger data, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> headers, OutputStream out) throws IOException {
        if (mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
            if (prettyPrint) {
                out.write(Json.pretty().writeValueAsString((Object)data).getBytes("utf-8"));
            } else {
                out.write(Json.mapper().writeValueAsString((Object)data).getBytes("utf-8"));
            }
        } else if (mediaType.toString().startsWith("application/yaml")) {
            out.write(yaml.writeValueAsString((Object)data).getBytes("utf-8"));
        } else if (mediaType.isCompatible(MediaType.APPLICATION_XML_TYPE)) {
            headers.remove((Object)"Content-Type");
            headers.add((Object)"Content-Type", (Object)"application/json");
            out.write(Json.mapper().writeValueAsString((Object)data).getBytes("utf-8"));
        }
    }

    static {
        prettyPrint = false;
        yaml = new ObjectMapper((JsonFactory)new YAMLFactory());
        yaml.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        yaml.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        yaml.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

