/*
 * Decompiled with CFR 0.152.
 */
package com.wywy.log4j.appender;

import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.komamitsu.fluency.Fluency;

@Plugin(name="FluencyConfig", category="Core", printObject=true)
public class FluencyConfig {
    private boolean ackResponseMode;
    private String fileBackupDir;
    private int bufferChunkInitialSize;
    private int bufferChunkRetentionSize;
    private Long maxBufferSize;
    private int waitUntilBufferFlushed;
    private int waitUntilFlusherTerminated;
    private int flushIntervalMillis;
    private int senderMaxRetryCount;

    private FluencyConfig() {
    }

    public Fluency.Config configure() {
        Fluency.Config config = new Fluency.Config().setAckResponseMode(this.ackResponseMode);
        if (this.fileBackupDir != null) {
            config.setFileBackupDir(this.fileBackupDir);
        }
        if (this.bufferChunkInitialSize > 0) {
            config.setBufferChunkInitialSize(Integer.valueOf(this.bufferChunkInitialSize));
        }
        if (this.bufferChunkRetentionSize > 0) {
            config.setBufferChunkRetentionSize(Integer.valueOf(this.bufferChunkRetentionSize));
        }
        if (this.maxBufferSize > 0L) {
            config.setMaxBufferSize(this.maxBufferSize);
        }
        if (this.waitUntilBufferFlushed > 0) {
            config.setWaitUntilBufferFlushed(Integer.valueOf(this.waitUntilBufferFlushed));
        }
        if (this.waitUntilFlusherTerminated > 0) {
            config.setWaitUntilFlusherTerminated(Integer.valueOf(this.waitUntilFlusherTerminated));
        }
        if (this.flushIntervalMillis > 0) {
            config.setFlushIntervalMillis(Integer.valueOf(this.flushIntervalMillis));
        }
        if (this.senderMaxRetryCount > 0) {
            config.setSenderMaxRetryCount(Integer.valueOf(this.senderMaxRetryCount));
        }
        return config;
    }

    @PluginFactory
    public static FluencyConfig createFluencyConfig(@PluginAttribute(value="ackResponseMode") boolean ackResponseMode, @PluginAttribute(value="fileBackupDir") String fileBackupDir, @PluginAttribute(value="bufferChunkInitialSize") int bufferChunkInitialSize, @PluginAttribute(value="bufferChunkRetentionSize") int bufferChunkRetentionSize, @PluginAttribute(value="maxBufferSize") Long maxBufferSize, @PluginAttribute(value="waitUntilBufferFlushed") int waitUntilBufferFlushed, @PluginAttribute(value="waitUntilFlusherTerminated") int waitUntilFlusherTerminated, @PluginAttribute(value="flushIntervalMillis") int flushIntervalMillis, @PluginAttribute(value="senderMaxRetryCount") int senderMaxRetryCount) {
        FluencyConfig config = new FluencyConfig();
        config.ackResponseMode = ackResponseMode;
        config.fileBackupDir = fileBackupDir;
        config.bufferChunkInitialSize = bufferChunkInitialSize;
        config.bufferChunkRetentionSize = bufferChunkRetentionSize;
        config.maxBufferSize = maxBufferSize;
        config.waitUntilBufferFlushed = waitUntilBufferFlushed;
        config.waitUntilFlusherTerminated = waitUntilFlusherTerminated;
        config.flushIntervalMillis = flushIntervalMillis;
        config.senderMaxRetryCount = senderMaxRetryCount;
        return config;
    }

    public String toString() {
        return "FluencyConfig{ackResponseMode=" + this.ackResponseMode + ", fileBackupDir='" + this.fileBackupDir + '\'' + ", bufferChunkInitialSize=" + this.bufferChunkInitialSize + ", bufferChunkRetentionSize=" + this.bufferChunkRetentionSize + ", maxBufferSize=" + this.maxBufferSize + ", waitUntilBufferFlushed=" + this.waitUntilBufferFlushed + ", waitUntilFlusherTerminated=" + this.waitUntilFlusherTerminated + ", flushIntervalMillis=" + this.flushIntervalMillis + ", senderMaxRetryCount=" + this.senderMaxRetryCount + '}';
    }
}

