/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    private static String OSName;

    private static boolean isWindowsOS() {
        if (OSName == null) {
            OSName = System.getProperties().getProperty("os.name").trim().toLowerCase();
        }
        return OSName.indexOf("window") > -1;
    }

    public static void zip(String zipPath, String zipFileName, File ... files) throws Exception, IOException {
        ArrayList<File> fileList = new ArrayList<File>();
        Collections.addAll(fileList, files);
        ZipUtil.zip(fileList, zipPath, zipFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(String srcPath, String zipPath, String zipFileName) throws Exception {
        if (srcPath == null || srcPath.length() == 0) {
            System.out.println("\u8981\u538b\u7f29\u7684\u6e90\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        if (zipPath == null || zipPath.length() == 0) {
            System.out.println("\u538b\u7f29\u6587\u4ef6\u4fdd\u5b58\u7684\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        CheckedOutputStream cos = null;
        ZipOutputStream zos = null;
        try {
            int index;
            String zipFilePath;
            File zipFile;
            File srcFile = new File(srcPath);
            if (srcFile.isDirectory() && zipPath.indexOf(srcPath) != -1) {
                throw new Exception("zipPath must not be the child directory of srcPath.");
            }
            File zipDir = new File(zipPath);
            if (!zipDir.exists() || !zipDir.isDirectory()) {
                zipDir.mkdirs();
            }
            if ((zipFile = new File(zipFilePath = zipPath + File.separator + zipFileName)).exists()) {
                SecurityManager securityManager = new SecurityManager();
                securityManager.checkDelete(zipFilePath);
                zipFile.delete();
            }
            cos = new CheckedOutputStream(new FileOutputStream(zipFile), new CRC32());
            zos = new ZipOutputStream(cos);
            String srcRootDir = srcPath;
            if (srcFile.isFile() && (index = srcPath.lastIndexOf(File.separator)) != -1) {
                srcRootDir = srcPath.substring(0, index);
            }
            if (ZipUtil.isWindowsOS()) {
                if (srcRootDir.indexOf("/") == 0) {
                    srcRootDir = srcRootDir.substring(1, srcRootDir.length());
                }
                if (srcPath.indexOf("/") == 0) {
                    srcPath = srcPath.substring(1, srcPath.length());
                }
            }
            ZipUtil.zip(srcRootDir, srcFile, zos, srcPath);
            zos.flush();
        }
        catch (Throwable throwable) {
            ZipUtil.closeQuietly(zos);
            throw throwable;
        }
        ZipUtil.closeQuietly(zos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(List<File> fileList, String zipPath, String zipFileName) throws Exception, IOException {
        if (null == fileList || fileList.isEmpty()) {
            throw new Exception("\u6587\u4ef6\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CheckedOutputStream cos = null;
        ZipOutputStream zos = null;
        try {
            String zipFilePath;
            File zipFile;
            for (File srcFile : fileList) {
                if (!srcFile.isDirectory() || zipPath.indexOf(srcFile.getPath()) == -1) continue;
                throw new Exception("zipPath must not be the child directory of srcPath.");
            }
            File zipDir = new File(zipPath);
            if (!zipDir.exists() || !zipDir.isDirectory()) {
                zipDir.mkdirs();
            }
            if ((zipFile = new File(zipFilePath = zipPath + File.separator + zipFileName)).exists()) {
                SecurityManager securityManager = new SecurityManager();
                securityManager.checkDelete(zipFilePath);
                zipFile.delete();
            }
            cos = new CheckedOutputStream(new FileOutputStream(zipFile), new CRC32());
            zos = new ZipOutputStream(cos);
            for (File srcFile : fileList) {
                String srcPath;
                String srcRootDir = srcPath = srcFile.getPath();
                int index = srcFile.getPath().lastIndexOf(File.separator);
                if (index != -1) {
                    srcRootDir = srcPath.substring(0, index);
                }
                ZipUtil.zip(srcRootDir, srcFile, zos, "   ");
            }
            zos.flush();
        }
        catch (Throwable throwable) {
            ZipUtil.closeQuietly(zos);
            throw throwable;
        }
        ZipUtil.closeQuietly(zos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zip(String srcRootDir, File file, ZipOutputStream zos, String srcPath) throws IOException {
        block9: {
            block8: {
                int index;
                if (file == null) {
                    return;
                }
                if (!file.isFile()) break block8;
                int bufferLen = 1024;
                byte[] data = new byte[bufferLen];
                String subPath = file.getAbsolutePath();
                if (ZipUtil.isWindowsOS()) {
                    subPath = subPath.replaceAll("\\\\", File.separator + File.separator);
                    srcPath = srcPath.replaceAll("/", File.separator + File.separator);
                }
                if ((index = subPath.indexOf(srcRootDir)) != -1) {
                    int srdLength = srcRootDir.length();
                    subPath = subPath.substring((srdLength > 1 ? srdLength - 1 : srdLength) + File.separator.length());
                }
                ZipEntry entry = new ZipEntry(subPath.replace(srcPath, "").replaceAll("\\\\", "/"));
                BufferedInputStream bis = null;
                try {
                    int count;
                    bis = new BufferedInputStream(new FileInputStream(file));
                    zos.putNextEntry(entry);
                    while ((count = bis.read(data, 0, bufferLen)) != -1) {
                        zos.write(data, 0, count);
                    }
                }
                catch (Throwable throwable) {
                    ZipUtil.closeQuietly(bis);
                    throw throwable;
                }
                ZipUtil.closeQuietly(bis);
                break block9;
            }
            File[] childFileList = file.listFiles();
            if (null == childFileList) {
                return;
            }
            for (File childFile : childFileList) {
                ZipUtil.zip(srcRootDir, childFile, zos, srcPath);
            }
        }
    }

    private static void closeQuietly(Closeable Closeable2) {
        if (null != Closeable2) {
            try {
                Closeable2.close();
                Closeable2 = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void unzip(String unzip) throws IOException {
        File file = new File(unzip);
        String basePath = file.getParent();
        FileInputStream fis = new FileInputStream(file);
        ZipInputStream zis = new ZipInputStream(fis);
        ZipUtil.unzip(zis, basePath + "/");
    }

    public static void unzip(String zipPath, String targetPath) throws IOException {
        File file = new File(zipPath);
        if (targetPath == null || targetPath.length() == 0) {
            targetPath = file.getParent();
        }
        FileInputStream fis = new FileInputStream(file);
        ZipInputStream zis = new ZipInputStream(fis);
        ZipUtil.unzip(zis, targetPath);
    }

    private static void unzip(ZipInputStream zis, String basePath) throws IOException {
        ZipEntry entry = zis.getNextEntry();
        if (entry != null) {
            File file = new File(basePath + entry.getName());
            if (entry.getName().endsWith(File.separator)) {
                if (!file.exists()) {
                    new File(basePath + entry.getName()).mkdirs();
                }
                ZipUtil.unzip(zis, basePath);
            } else {
                File parentFile = file.getParentFile();
                if (parentFile != null && !parentFile.exists()) {
                    parentFile.mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(file);
                int len = 0;
                byte[] buf = new byte[1024];
                while ((len = zis.read(buf)) != -1) {
                    fos.write(buf, 0, len);
                }
                fos.flush();
                fos.close();
                zis.closeEntry();
                ZipUtil.unzip(zis, basePath);
            }
        }
    }

    public static void main(String[] args) {
        try {
            ZipUtil.zip("/Users/apple/Downloads/1w11", "/Users/apple/Downloads/", "1wa.zip");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

