/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.activitystream.impl;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.SyndFeedOutput;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.notify.DocChangeRule;
import com.xpn.xwiki.notify.XWikiDocChangeNotificationInterface;
import com.xpn.xwiki.notify.XWikiNotificationRule;
import com.xpn.xwiki.plugin.activitystream.api.ActivityEvent;
import com.xpn.xwiki.plugin.activitystream.api.ActivityStream;
import com.xpn.xwiki.plugin.activitystream.api.ActivityStreamException;
import com.xpn.xwiki.plugin.activitystream.impl.ActivityEventImpl;
import com.xpn.xwiki.store.XWikiHibernateStore;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.RandomStringUtils;
import org.hibernate.Query;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityStreamImpl
implements ActivityStream,
XWikiDocChangeNotificationInterface {
    @Override
    public void initClasses(XWikiContext context) throws XWikiException {
        context.getWiki().getNotificationManager().addGeneralRule((XWikiNotificationRule)new DocChangeRule((XWikiDocChangeNotificationInterface)this));
    }

    protected void prepareEvent(ActivityEvent event, XWikiDocument doc, XWikiContext context) {
        if (doc == null) {
            doc = context.getDoc();
        }
        if (event.getUser() == null) {
            event.setUser(context.getUser());
        }
        if (event.getStream() == null) {
            String space = doc == null ? "" : doc.getSpace();
            event.setStream(this.getStreamName(space, context));
        }
        if (event.getWiki() == null) {
            event.setWiki(context.getDatabase());
        }
        if (event.getSpace() == null) {
            event.setSpace(doc == null ? "" : doc.getSpace());
        }
        if (event.getPage() == null) {
            event.setPage(doc == null ? "" : doc.getFullName());
        }
        if (event.getUrl() == null) {
            event.setUrl(doc == null ? "" : doc.getURL("view", context));
        }
        if (event.getApplication() == null) {
            event.setApplication("xwiki");
        }
        if (event.getDate() == null) {
            event.setDate(context.getWiki().getCurrentDate());
        }
        if (event.getEventId() == null) {
            event.setEventId(this.generateEventId(event, context));
        }
        if (event.getRequestId() == null) {
            event.setRequestId((String)context.get((Object)"activitystream_requestid"));
        }
    }

    @Override
    public String getStreamName(String space, XWikiContext context) {
        return space;
    }

    protected String generateEventId(ActivityEvent event, XWikiContext context) {
        String key = event.getStream() + "-" + event.getApplication() + "-" + event.getWiki() + ":" + event.getPage() + "-" + event.getType();
        long hash = key.hashCode();
        if (hash < 0L) {
            hash = -hash;
        }
        String id = "" + hash + "-" + event.getDate().getTime() + "-" + RandomStringUtils.randomAlphanumeric((int)8);
        if (context.get((Object)"activitystream_requestid") == null) {
            context.put((Object)"activitystream_requestid", (Object)id);
        }
        return id;
    }

    @Override
    public void addActivityEvent(ActivityEvent event, XWikiContext context) throws ActivityStreamException {
        this.addActivityEvent(event, null, context);
    }

    public void addActivityEvent(ActivityEvent event, XWikiDocument doc, XWikiContext context) throws ActivityStreamException {
        this.prepareEvent(event, doc, context);
        XWikiHibernateStore hibstore = context.getWiki().getHibernateStore();
        try {
            hibstore.beginTransaction(context);
            Session session = hibstore.getSession(context);
            session.save((Object)event);
            hibstore.endTransaction(context, true);
        }
        catch (XWikiException e) {
            hibstore.endTransaction(context, false);
        }
    }

    @Override
    public void addActivityEvent(String streamName, String type, String title, XWikiContext context) throws ActivityStreamException {
        this.addActivityEvent(streamName, type, title, null, context);
    }

    @Override
    public void addActivityEvent(String streamName, String type, String title, List<String> params, XWikiContext context) throws ActivityStreamException {
        ActivityEvent event = this.newActivityEvent();
        event.setStream(streamName);
        event.setType(type);
        event.setTitle(title);
        event.setBody(title);
        event.setParams(params);
        this.addActivityEvent(event, context);
    }

    @Override
    public void addDocumentActivityEvent(String streamName, XWikiDocument doc, String type, String title, XWikiContext context) throws ActivityStreamException {
        this.addDocumentActivityEvent(streamName, doc, type, 20, title, null, context);
    }

    @Override
    public void addDocumentActivityEvent(String streamName, XWikiDocument doc, String type, int priority, String title, XWikiContext context) throws ActivityStreamException {
        this.addDocumentActivityEvent(streamName, doc, type, priority, title, null, context);
    }

    @Override
    public void addDocumentActivityEvent(String streamName, XWikiDocument doc, String type, String title, List<String> params, XWikiContext context) throws ActivityStreamException {
        this.addDocumentActivityEvent(streamName, doc, type, 20, title, params, context);
    }

    @Override
    public void addDocumentActivityEvent(String streamName, XWikiDocument doc, String type, int priority, String title, List<String> params, XWikiContext context) throws ActivityStreamException {
        ActivityEvent event = this.newActivityEvent();
        event.setStream(streamName);
        event.setPage(doc.getFullName());
        if (doc.getDatabase() != null) {
            event.setWiki(doc.getDatabase());
        }
        event.setDate(doc.getDate());
        event.setPriority(priority);
        event.setType(type);
        event.setTitle(title);
        event.setBody(title);
        event.setVersion(doc.getVersion());
        event.setParams(params);
        this.addActivityEvent(event, doc, context);
    }

    private ActivityEventImpl loadActivityEvent(ActivityEvent ev, boolean bTransaction, XWikiContext context) throws ActivityStreamException {
        ActivityEventImpl act = null;
        String eventId = ev.getEventId();
        XWikiHibernateStore hibstore = context.getWiki().getHibernateStore();
        try {
            if (bTransaction) {
                hibstore.checkHibernate(context);
                bTransaction = hibstore.beginTransaction(false, context);
            }
            Session session = hibstore.getSession(context);
            Query query = session.createQuery("select act.eventId from ActivityEventImpl as act where act.eventId = :eventId");
            query.setString("eventId", eventId);
            if (query.uniqueResult() != null) {
                act = new ActivityEventImpl();
                session.load((Object)act, (Serializable)((Object)eventId));
            }
            if (bTransaction) {
                hibstore.endTransaction(context, false, false);
            }
        }
        catch (Exception e) {
            throw new ActivityStreamException();
        }
        finally {
            try {
                if (bTransaction) {
                    hibstore.endTransaction(context, false, false);
                }
            }
            catch (Exception e) {}
        }
        return act;
    }

    @Override
    public void deleteActivityEvent(ActivityEvent event, XWikiContext context) throws ActivityStreamException {
        boolean bTransaction = true;
        ActivityEventImpl evImpl = this.loadActivityEvent(event, true, context);
        XWikiHibernateStore hibstore = context.getWiki().getHibernateStore();
        try {
            if (bTransaction) {
                hibstore.checkHibernate(context);
                bTransaction = hibstore.beginTransaction(context);
            }
            Session session = hibstore.getSession(context);
            session.delete((Object)evImpl);
            if (bTransaction) {
                hibstore.endTransaction(context, true);
            }
        }
        catch (XWikiException e) {
            throw new ActivityStreamException();
        }
        finally {
            try {
                if (bTransaction) {
                    hibstore.endTransaction(context, false);
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public List<ActivityEvent> searchEvents(String hql, boolean filter, int nb, int start, XWikiContext context) throws ActivityStreamException {
        return this.searchEvents("", hql, filter, nb, start, context);
    }

    @Override
    public List<ActivityEvent> searchEvents(String fromHql, String hql, boolean filter, int nb, int start, XWikiContext context) throws ActivityStreamException {
        return this.searchEvents(fromHql, hql, filter, nb, start, null, context);
    }

    @Override
    public List<ActivityEvent> searchEvents(String fromHql, String hql, boolean filter, int nb, int start, List<Object> parameterValues, XWikiContext context) throws ActivityStreamException {
        StringBuffer searchHql = new StringBuffer();
        if (filter) {
            searchHql.append("select act from ActivityEventImpl as act, ActivityEventImpl as act2 ");
            searchHql.append(fromHql);
            searchHql.append(" where act.eventId=act2.eventId and ");
            searchHql.append(hql);
            searchHql.append(" group by act.requestId having (act.priority)=max(act2.priority) order by act.date desc");
        } else {
            searchHql.append("select act from ActivityEventImpl as act ");
            searchHql.append(fromHql);
            searchHql.append(" where ");
            searchHql.append(hql);
            searchHql.append(" order by act.date desc");
        }
        try {
            return context.getWiki().getStore().search(searchHql.toString(), nb, start, parameterValues, context);
        }
        catch (XWikiException e) {
            throw new ActivityStreamException(e);
        }
    }

    @Override
    public List<ActivityEvent> getEvents(boolean filter, int nb, int start, XWikiContext context) throws ActivityStreamException {
        return this.searchEvents("1=1", filter, nb, start, context);
    }

    @Override
    public List<ActivityEvent> getEventsForSpace(String space, boolean filter, int nb, int start, XWikiContext context) throws ActivityStreamException {
        return this.searchEvents("act.space='" + space + "'", filter, nb, start, context);
    }

    @Override
    public List<ActivityEvent> getEventsForUser(String user, boolean filter, int nb, int start, XWikiContext context) throws ActivityStreamException {
        return this.searchEvents("act.user='" + user + "'", filter, nb, start, context);
    }

    @Override
    public List<ActivityEvent> getEvents(String stream, boolean filter, int nb, int start, XWikiContext context) throws ActivityStreamException {
        return this.searchEvents("act.stream='" + stream + "'", filter, nb, start, context);
    }

    @Override
    public List<ActivityEvent> getEventsForSpace(String stream, String space, boolean filter, int nb, int start, XWikiContext context) throws ActivityStreamException {
        return this.searchEvents("act.space='" + space + "' and act.stream='" + stream + "'", filter, nb, start, context);
    }

    @Override
    public List<ActivityEvent> getEventsForUser(String stream, String user, boolean filter, int nb, int start, XWikiContext context) throws ActivityStreamException {
        return this.searchEvents("act.user='" + user + "' and act.stream='" + stream + "'", filter, nb, start, context);
    }

    protected ActivityEvent newActivityEvent() {
        return new ActivityEventImpl();
    }

    public void notify(XWikiNotificationRule rule, XWikiDocument newdoc, XWikiDocument olddoc, int event, XWikiContext context) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(0, newdoc.getDisplayTitle(context));
        String streamName = this.getStreamName(newdoc.getSpace(), context);
        if (streamName == null) {
            return;
        }
        try {
            switch (event) {
                case 0: {
                    if (olddoc == null || olddoc.isNew()) {
                        this.addDocumentActivityEvent(streamName, newdoc, "create", "as_document_has_been_created", params, context);
                        break;
                    }
                    if (newdoc == null || newdoc.isNew()) {
                        this.addDocumentActivityEvent(streamName, newdoc, "delete", "as_document_has_been_deleted", params, context);
                        break;
                    }
                    this.addDocumentActivityEvent(streamName, newdoc, "update", "as_document_has_been_updated", params, context);
                    break;
                }
                case 1: {
                    this.addDocumentActivityEvent(streamName, newdoc, "create", "as_document_has_been_created", params, context);
                    break;
                }
                case 2: {
                    this.addDocumentActivityEvent(streamName, newdoc, "delete", "as_document_has_been_deleted", params, context);
                    break;
                }
                case 3: {
                    this.addDocumentActivityEvent(streamName, newdoc, "update", "as_document_has_been_updated", params, context);
                    break;
                }
                case 4: {
                    this.addDocumentActivityEvent(streamName, newdoc, "update", "as_document_has_been_updated", params, context);
                    break;
                }
                case 5: {
                    this.addDocumentActivityEvent(streamName, newdoc, "update", "as_document_has_been_updated", params, context);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public SyndEntry getFeedEntry(ActivityEvent event, XWikiContext context) {
        return this.getFeedEntry(event, "", context);
    }

    @Override
    public SyndEntry getFeedEntry(ActivityEvent event, String suffix, XWikiContext context) {
        String url;
        SyndEntryImpl entry = new SyndEntryImpl();
        String user = event.getUser();
        String displayUser = context.getWiki().getUserName(user, null, false, context);
        entry.setAuthor(displayUser);
        event.setTitle(event.getTitle() + suffix);
        entry.setTitle(event.getDisplayTitle(context));
        event.setBody(event.getBody() + suffix + "_body");
        SyndContentImpl sc = new SyndContentImpl();
        sc.setValue(event.getDisplayBody(context));
        sc.setType("text/html");
        entry.setDescription((SyndContent)sc);
        try {
            url = new URL(context.getURL(), event.getUrl()).toString();
        }
        catch (MalformedURLException e) {
            url = event.getUrl();
        }
        entry.setLink(url);
        entry.setPublishedDate(event.getDate());
        entry.setUpdatedDate(event.getDate());
        return entry;
    }

    @Override
    public SyndFeed getFeed(List<ActivityEvent> events, XWikiContext context) {
        return this.getFeed(events, "", context);
    }

    @Override
    public SyndFeed getFeed(List<ActivityEvent> events, String suffix, XWikiContext context) {
        SyndFeedImpl feed = new SyndFeedImpl();
        ArrayList<SyndEntry> entries = new ArrayList<SyndEntry>();
        for (ActivityEvent event : events) {
            SyndEntry entry = this.getFeedEntry(event, suffix, context);
            entries.add(entry);
        }
        feed.setEntries(entries);
        return feed;
    }

    @Override
    public SyndFeed getFeed(List<ActivityEvent> events, String author, String title, String description, String copyright, String encoding, String url, XWikiContext context) {
        return this.getFeed(events, author, title, description, copyright, encoding, url, "", context);
    }

    @Override
    public SyndFeed getFeed(List<ActivityEvent> events, String author, String title, String description, String copyright, String encoding, String url, String suffix, XWikiContext context) {
        SyndFeed feed = this.getFeed(events, suffix, context);
        feed.setAuthor(author);
        feed.setDescription(description);
        feed.setCopyright(copyright);
        feed.setEncoding(encoding);
        feed.setLink(url);
        feed.setTitle(title);
        return feed;
    }

    @Override
    public String getFeedOutput(List<ActivityEvent> events, String author, String title, String description, String copyright, String encoding, String url, String type, XWikiContext context) {
        return this.getFeedOutput(events, author, title, description, copyright, encoding, url, type, "", context);
    }

    @Override
    public String getFeedOutput(List<ActivityEvent> events, String author, String title, String description, String copyright, String encoding, String url, String type, String suffix, XWikiContext context) {
        SyndFeed feed = this.getFeed(events, author, title, description, copyright, encoding, url, suffix, context);
        return this.getFeedOutput(feed, type);
    }

    @Override
    public String getFeedOutput(SyndFeed feed, String type) {
        feed.setFeedType(type);
        StringWriter writer = new StringWriter();
        SyndFeedOutput output = new SyndFeedOutput();
        try {
            output.output(feed, (Writer)writer);
            writer.close();
            return writer.toString();
        }
        catch (Exception e) {
            return "";
        }
    }
}

