/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.activitystream.plugin;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.plugin.PluginApi;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.activitystream.api.ActivityStream;
import com.xpn.xwiki.plugin.activitystream.api.ActivityStreamException;
import com.xpn.xwiki.plugin.activitystream.plugin.ActivityEvent;
import com.xpn.xwiki.plugin.activitystream.plugin.ActivityStreamPlugin;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityStreamPluginApi
extends PluginApi<ActivityStreamPlugin> {
    public ActivityStreamPluginApi(ActivityStreamPlugin plugin, XWikiContext context) {
        super((XWikiPluginInterface)plugin, context);
    }

    protected ActivityStream getActivityStream() {
        return ((ActivityStreamPlugin)this.getProtectedPlugin()).getActivityStream();
    }

    public void addActivityEvent(com.xpn.xwiki.plugin.activitystream.api.ActivityEvent event) throws ActivityStreamException {
        if (this.hasProgrammingRights()) {
            this.getActivityStream().addActivityEvent(event, this.context);
        }
    }

    public void addActivityEvent(String streamName, String type, String title) throws ActivityStreamException {
        if (this.hasProgrammingRights()) {
            this.getActivityStream().addActivityEvent(streamName, type, title, this.context);
        }
    }

    public void addActivityEvent(String streamName, String type, String title, List<String> params) throws ActivityStreamException {
        if (this.hasProgrammingRights()) {
            this.getActivityStream().addActivityEvent(streamName, type, title, params, this.context);
        }
    }

    public void addDocumentActivityEvent(String streamName, Document doc, String type, String title) throws ActivityStreamException {
        if (this.hasProgrammingRights()) {
            this.getActivityStream().addDocumentActivityEvent(streamName, doc.getDocument(), type, title, this.context);
        }
    }

    public void addDocumentActivityEvent(String streamName, Document doc, String type, int priority, String title) throws ActivityStreamException {
        if (this.hasProgrammingRights()) {
            this.getActivityStream().addDocumentActivityEvent(streamName, doc.getDocument(), type, priority, title, this.context);
        }
    }

    public void deleteActivityEvents(List<ActivityEvent> evs) throws ActivityStreamException {
        if (this.hasProgrammingRights()) {
            List<com.xpn.xwiki.plugin.activitystream.api.ActivityEvent> events = this.unwrapEvents(evs);
            for (com.xpn.xwiki.plugin.activitystream.api.ActivityEvent ev : events) {
                this.getActivityStream().deleteActivityEvent(ev, this.context);
            }
        }
    }

    public void deleteActivityEvent(ActivityEvent event) throws ActivityStreamException {
        if (this.hasProgrammingRights()) {
            this.getActivityStream().deleteActivityEvent(event.getEvent(), this.context);
        }
    }

    public void addDocumentActivityEvent(String streamName, Document doc, String type, String title, List<String> params) throws ActivityStreamException {
        if (this.hasProgrammingRights()) {
            this.getActivityStream().addDocumentActivityEvent(streamName, doc.getDocument(), type, title, params, this.context);
        }
    }

    public void addDocumentActivityEvent(String streamName, Document doc, String type, int priority, String title, List<String> params) throws ActivityStreamException {
        if (this.hasProgrammingRights()) {
            this.getActivityStream().addDocumentActivityEvent(streamName, doc.getDocument(), type, priority, title, params, this.context);
        }
    }

    public List<ActivityEvent> searchEvents(String hql, boolean filter, int nb, int start) throws ActivityStreamException {
        if (this.hasProgrammingRights()) {
            return this.wrapEvents(this.getActivityStream().searchEvents(hql, filter, nb, start, this.context));
        }
        return null;
    }

    public List<ActivityEvent> searchEvents(String hql, boolean filter, boolean globalSearch, int nb, int start) throws ActivityStreamException {
        if (this.hasProgrammingRights()) {
            return this.wrapEvents(this.getActivityStream().searchEvents(hql, filter, globalSearch, nb, start, this.context));
        }
        return null;
    }

    public List<ActivityEvent> searchEvents(String hql, boolean filter, int nb, int start, List<Object> parameterValues) throws ActivityStreamException {
        if (this.hasProgrammingRights()) {
            return this.wrapEvents(this.getActivityStream().searchEvents("", hql, filter, nb, start, parameterValues, this.context));
        }
        return null;
    }

    public List<ActivityEvent> searchEvents(String hql, boolean filter, boolean globalSearch, int nb, int start, List<Object> parameterValues) throws ActivityStreamException {
        if (this.hasProgrammingRights()) {
            return this.wrapEvents(this.getActivityStream().searchEvents("", hql, filter, globalSearch, nb, start, parameterValues, this.context));
        }
        return null;
    }

    public List<ActivityEvent> searchEvents(String fromHql, String hql, boolean filter, int nb, int start) throws ActivityStreamException {
        if (this.hasProgrammingRights()) {
            return this.wrapEvents(this.getActivityStream().searchEvents(fromHql, hql, filter, nb, start, this.context));
        }
        return null;
    }

    public List<ActivityEvent> searchEvents(String fromHql, String hql, boolean filter, boolean globalSearch, int nb, int start) throws ActivityStreamException {
        if (this.hasProgrammingRights()) {
            return this.wrapEvents(this.getActivityStream().searchEvents(fromHql, hql, filter, globalSearch, nb, start, this.context));
        }
        return null;
    }

    public List<ActivityEvent> searchEvents(String fromHql, String hql, boolean filter, int nb, int start, List<Object> parameterValues) throws ActivityStreamException {
        if (this.hasProgrammingRights()) {
            return this.wrapEvents(this.getActivityStream().searchEvents(fromHql, hql, filter, nb, start, this.context));
        }
        return null;
    }

    public List<ActivityEvent> searchEvents(String fromHql, String hql, boolean filter, boolean globalSearch, int nb, int start, List<Object> parameterValues) throws ActivityStreamException {
        if (this.hasProgrammingRights()) {
            return this.wrapEvents(this.getActivityStream().searchEvents(fromHql, hql, filter, globalSearch, nb, start, this.context));
        }
        return null;
    }

    public List<ActivityEvent> getEvents(boolean filter, int nb, int start) throws ActivityStreamException {
        if (this.hasProgrammingRights()) {
            return this.wrapEvents(this.getActivityStream().getEvents(filter, nb, start, this.context));
        }
        return null;
    }

    public List<ActivityEvent> getEventsForSpace(String space, boolean filter, int nb, int start) throws ActivityStreamException {
        if (this.hasProgrammingRights()) {
            return this.wrapEvents(this.getActivityStream().getEventsForSpace(space, filter, nb, start, this.context));
        }
        return null;
    }

    public List<ActivityEvent> getEventsForUser(String user, boolean filter, int nb, int start) throws ActivityStreamException {
        if (this.hasProgrammingRights()) {
            return this.wrapEvents(this.getActivityStream().getEventsForUser(user, filter, nb, start, this.context));
        }
        return null;
    }

    public List<ActivityEvent> getEvents(String streamName, boolean filter, int nb, int start) throws ActivityStreamException {
        if (this.hasProgrammingRights()) {
            return this.wrapEvents(this.getActivityStream().getEvents(streamName, filter, nb, start, this.context));
        }
        return null;
    }

    public List<ActivityEvent> getEventsForSpace(String streamName, String space, boolean filter, int nb, int start) throws ActivityStreamException {
        if (this.hasProgrammingRights()) {
            return this.wrapEvents(this.getActivityStream().getEventsForSpace(streamName, space, filter, nb, start, this.context));
        }
        return null;
    }

    public List<ActivityEvent> getEventsForUser(String streamName, String user, boolean filter, int nb, int start) throws ActivityStreamException {
        if (this.hasProgrammingRights()) {
            return this.wrapEvents(this.getActivityStream().getEventsForUser(streamName, user, filter, nb, start, this.context));
        }
        return null;
    }

    private List<ActivityEvent> wrapEvents(List<com.xpn.xwiki.plugin.activitystream.api.ActivityEvent> events) {
        ArrayList<ActivityEvent> result = new ArrayList<ActivityEvent>();
        if (events != null) {
            for (com.xpn.xwiki.plugin.activitystream.api.ActivityEvent event : events) {
                ActivityEvent wrappedEvent = new ActivityEvent(event, this.getXWikiContext());
                result.add(wrappedEvent);
            }
        }
        return result;
    }

    private List<com.xpn.xwiki.plugin.activitystream.api.ActivityEvent> unwrapEvents(List<ActivityEvent> events) {
        ArrayList<com.xpn.xwiki.plugin.activitystream.api.ActivityEvent> result = new ArrayList<com.xpn.xwiki.plugin.activitystream.api.ActivityEvent>();
        if (events != null) {
            for (ActivityEvent event : events) {
                com.xpn.xwiki.plugin.activitystream.api.ActivityEvent unwrappedEvent = event.getEvent();
                result.add(unwrappedEvent);
            }
        }
        return result;
    }

    public SyndEntry getFeedEntry(ActivityEvent event) {
        return this.getActivityStream().getFeedEntry(event.getEvent(), this.context);
    }

    public SyndEntry getFeedEntry(ActivityEvent event, String suffix) {
        return this.getActivityStream().getFeedEntry(event.getEvent(), suffix, this.context);
    }

    public SyndFeed getFeed(List<ActivityEvent> events) {
        return this.getActivityStream().getFeed(this.unwrapEvents(events), this.context);
    }

    public SyndFeed getFeed(List<ActivityEvent> events, String suffix) {
        return this.getActivityStream().getFeed(this.unwrapEvents(events), suffix, this.context);
    }

    public SyndFeed getFeed(List<ActivityEvent> events, String author, String title, String description, String copyright, String encoding, String url) {
        return this.getActivityStream().getFeed(this.unwrapEvents(events), author, title, description, copyright, encoding, url, this.context);
    }

    public SyndFeed getFeed(List<ActivityEvent> events, String author, String title, String description, String copyright, String encoding, String url, String suffix) {
        return this.getActivityStream().getFeed(this.unwrapEvents(events), author, title, description, copyright, encoding, url, suffix, this.context);
    }

    public String getFeedOutput(List<ActivityEvent> events, String author, String title, String description, String copyright, String encoding, String url, String type) {
        return this.getActivityStream().getFeedOutput(this.unwrapEvents(events), author, title, description, copyright, encoding, url, type, this.context);
    }

    public String getFeedOutput(List<ActivityEvent> events, String author, String title, String description, String copyright, String encoding, String url, String type, String suffix) {
        return this.getActivityStream().getFeedOutput(this.unwrapEvents(events), author, title, description, copyright, encoding, url, type, suffix, this.context);
    }

    public String getFeedOutput(SyndFeed feed, String type) {
        return this.getActivityStream().getFeedOutput(feed, type);
    }

    public String getStreamName(String spaceName) {
        return this.getActivityStream().getStreamName(spaceName, this.context);
    }
}

