/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.lucene;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.lucene.IndexData;
import com.xpn.xwiki.plugin.lucene.TextExtractor;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class AttachmentData
extends IndexData {
    static final Map<String, String> MIMETYPES = new HashMap<String, String>();
    private static final Log LOG;
    private int size;
    private String filename;

    public AttachmentData(XWikiDocument document, XWikiAttachment attachment, XWikiContext context) {
        super(attachment.getDoc(), context);
        this.setModificationDate(attachment.getDate());
        this.setAuthor(attachment.getAuthor());
        this.setSize(attachment.getFilesize());
        this.setFilename(attachment.getFilename());
    }

    public void addDataToLuceneDocument(Document luceneDoc, XWikiDocument doc, XWikiContext context) {
        super.addDataToLuceneDocument(luceneDoc, doc, context);
        if (this.filename != null) {
            luceneDoc.add((Fieldable)new Field("filename", this.filename, Field.Store.YES, Field.Index.TOKENIZED));
        }
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getType() {
        return "attachment";
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getId() {
        return new StringBuffer(super.getId()).append(".file.").append(this.filename).toString();
    }

    public String getFullText(XWikiDocument doc, XWikiContext context) {
        StringBuffer retval = new StringBuffer(super.getFullText(doc, context));
        String contentText = null;
        contentText = this.getContentAsText(doc, context);
        if (contentText != null) {
            retval.append(" ").append(contentText).toString();
        }
        return retval.toString();
    }

    private String getContentAsText(XWikiDocument doc, XWikiContext context) {
        String contentText = null;
        try {
            String[] nameParts;
            XWikiAttachment att = doc.getAttachment(this.filename);
            LOG.debug((Object)("have attachment for filename " + this.filename + ": " + att));
            byte[] content = att.getContent(context);
            if (this.filename != null && (nameParts = this.filename.split("\\.")).length > 1) {
                contentText = TextExtractor.getText(content, MIMETYPES.get(nameParts[nameParts.length - 1].toLowerCase()));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"error getting content of attachment", (Throwable)e);
        }
        return contentText;
    }

    static {
        MIMETYPES.put("pdf", "application/pdf");
        MIMETYPES.put("doc", "application/msword");
        MIMETYPES.put("sxw", "application/vnd.sun.xml.writer");
        MIMETYPES.put("xml", "text/xml");
        MIMETYPES.put("txt", "text/plain");
        MIMETYPES.put("ppt", "application/ms-powerpoint");
        MIMETYPES.put("xls", "application/ms-excel");
        LOG = LogFactory.getLog(AttachmentData.class);
    }
}

