/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.lucene;

import com.xpn.xwiki.plugin.lucene.textextraction.MSExcelTextExtractor;
import com.xpn.xwiki.plugin.lucene.textextraction.MSPowerPointTextExtractor;
import com.xpn.xwiki.plugin.lucene.textextraction.MSWordTextExtractor;
import com.xpn.xwiki.plugin.lucene.textextraction.MimetypeTextExtractor;
import com.xpn.xwiki.plugin.lucene.textextraction.PDFTextExtractor;
import com.xpn.xwiki.plugin.lucene.textextraction.PlainTextExtractor;
import com.xpn.xwiki.plugin.lucene.textextraction.XmlTextExtractor;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TextExtractor {
    private static final Log LOG = LogFactory.getLog(TextExtractor.class);
    static final Map<String, MimetypeTextExtractor> textExtractors = new HashMap<String, MimetypeTextExtractor>();

    public static String getText(byte[] content, String mimetype) {
        MimetypeTextExtractor extractor = textExtractors.get(mimetype);
        if (extractor != null) {
            try {
                return extractor.getText(content);
            }
            catch (Exception e) {
                LOG.error((Object)("error getting text for mimetype " + mimetype), (Throwable)e);
                e.printStackTrace();
            }
        } else {
            LOG.info((Object)("no text extractor for mimetype " + mimetype));
        }
        return null;
    }

    static {
        XmlTextExtractor xmlTextExtractor = new XmlTextExtractor();
        textExtractors.put("application/xhtml+xml", xmlTextExtractor);
        textExtractors.put("text/xml", xmlTextExtractor);
        textExtractors.put("text/plain", new PlainTextExtractor());
        textExtractors.put("application/pdf", new PDFTextExtractor());
        textExtractors.put("application/msword", new MSWordTextExtractor());
        textExtractors.put("application/ms-word", new MSWordTextExtractor());
        textExtractors.put("application/vnd.msword", new MSWordTextExtractor());
        textExtractors.put("application/vnd.ms-word", new MSWordTextExtractor());
        textExtractors.put("application/vnd.ms-powerpoint", new MSPowerPointTextExtractor());
        textExtractors.put("application/ms-powerpoint", new MSPowerPointTextExtractor());
        textExtractors.put("application/ms-excel", new MSExcelTextExtractor());
        textExtractors.put("application/vnd.ms-excel", new MSExcelTextExtractor());
    }
}

