/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.lucene;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.lucene.IndexFields;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.xwiki.rendering.syntax.Syntax;

public abstract class IndexData {
    private static final Log LOG = LogFactory.getLog(IndexData.class);
    private String documentTitle;
    private String documentName;
    private String documentSpace;
    private String documentFullName;
    private String fullName;
    private String author;
    private Date creationDate;
    private String creator;
    private String language;
    private Date modificationDate;
    private String wiki;

    public IndexData(XWikiDocument doc, XWikiContext context) {
        this.setDocumentName(doc.getName());
        this.setDocumentTitle(doc.getRenderedTitle(Syntax.PLAIN_1_0, context));
        this.setDocumentSpace(doc.getSpace());
        this.setDocumentFullName(doc.getFullName());
        this.setWiki(doc.getDatabase() == null ? context.getDatabase() : doc.getDatabase());
        this.setFullName(new StringBuffer(this.wiki).append(":").append(this.documentSpace).append(".").append(this.documentName).toString());
        this.setLanguage(doc.getLanguage());
    }

    public void addDataToLuceneDocument(Document luceneDoc, XWikiDocument doc, XWikiContext context) {
        luceneDoc.add((Fieldable)new Field("_docid", this.getId(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        luceneDoc.add((Fieldable)new Field("lang", this.language, Field.Store.YES, Field.Index.ANALYZED));
        if (!StringUtils.isEmpty((String)this.wiki)) {
            luceneDoc.add((Fieldable)new Field("wiki", this.wiki, Field.Store.YES, Field.Index.ANALYZED));
        }
        if (this.getType() != null) {
            luceneDoc.add((Fieldable)new Field("type", this.getType(), Field.Store.YES, Field.Index.ANALYZED));
        }
        if (this.modificationDate != null) {
            luceneDoc.add((Fieldable)new Field("date", IndexFields.dateToString(this.modificationDate), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        if (this.creationDate != null) {
            luceneDoc.add((Fieldable)new Field("creationdate", IndexFields.dateToString(this.creationDate), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        if (this.documentTitle != null) {
            luceneDoc.add((Fieldable)new Field("title", this.documentTitle, Field.Store.YES, Field.Index.ANALYZED));
        }
        luceneDoc.add((Fieldable)new Field("name", this.documentName, Field.Store.YES, Field.Index.ANALYZED));
        luceneDoc.add((Fieldable)new Field("web", this.documentSpace, Field.Store.YES, Field.Index.ANALYZED));
        luceneDoc.add((Fieldable)new Field("fullname", this.documentFullName, Field.Store.YES, Field.Index.ANALYZED));
        if (this.author != null) {
            luceneDoc.add((Fieldable)new Field("author", this.author, Field.Store.YES, Field.Index.ANALYZED));
        }
        if (this.creator != null) {
            luceneDoc.add((Fieldable)new Field("creator", this.creator, Field.Store.YES, Field.Index.ANALYZED));
        }
        try {
            String ft = this.getFullText(doc, context);
            if (ft != null) {
                luceneDoc.add((Fieldable)new Field("ft", ft, Field.Store.NO, Field.Index.ANALYZED));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error extracting fulltext for document [" + this + "]"), (Throwable)e);
        }
    }

    public Query buildQuery() {
        return new TermQuery(new Term("_docid", this.getId()));
    }

    public String getId() {
        StringBuffer retval = new StringBuffer();
        if (!StringUtils.isEmpty((String)this.wiki)) {
            retval.append(this.wiki).append(":");
        }
        retval.append(this.documentSpace).append(".");
        retval.append(this.documentName).append(".");
        retval.append(this.language);
        return retval.toString();
    }

    public String getFullText(XWikiDocument doc, XWikiContext context) {
        StringBuilder sb = new StringBuilder();
        this.getFullText(sb, doc, context);
        return sb.toString();
    }

    protected void getFullText(StringBuilder sb, XWikiDocument doc, XWikiContext context) {
        sb.append(this.documentName).append(" ").append(this.documentSpace).append(" ").append(this.author).append(" ").append(this.creator);
    }

    public abstract String getType();

    public String toString() {
        return this.getId();
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setDocumentTitle(String documentTitle) {
        this.documentTitle = documentTitle;
    }

    public void setDocumentName(String documentName) {
        this.documentName = documentName;
    }

    @Deprecated
    public void setDocumentWeb(String documentWeb) {
        this.setDocumentSpace(documentWeb);
    }

    public void setDocumentSpace(String documentSpace) {
        this.documentSpace = documentSpace;
    }

    public void setDocumentFullName(String documentFullName) {
        this.documentFullName = documentFullName;
    }

    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
    }

    public String getDocumentTitle() {
        return this.documentTitle;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    @Deprecated
    public String getDocumentWeb() {
        return this.getDocumentSpace();
    }

    public String getDocumentSpace() {
        return this.documentSpace;
    }

    public String getDocumentFullName() {
        return this.documentFullName;
    }

    public String getWiki() {
        return this.wiki;
    }

    public void setWiki(String wiki) {
        this.wiki = wiki;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String lang) {
        this.language = !StringUtils.isEmpty((String)lang) ? lang : "default";
    }
}

