/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.lucene;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.lucene.AttachmentData;
import com.xpn.xwiki.plugin.lucene.DocumentData;
import com.xpn.xwiki.plugin.lucene.IndexData;
import com.xpn.xwiki.plugin.lucene.LucenePlugin;
import com.xpn.xwiki.plugin.lucene.XWikiDocumentQueue;
import com.xpn.xwiki.util.AbstractXWikiRunnable;
import com.xpn.xwiki.web.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.MDC;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.xwiki.context.Execution;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.ActionExecutionEvent;
import org.xwiki.observation.event.DocumentDeleteEvent;
import org.xwiki.observation.event.DocumentSaveEvent;
import org.xwiki.observation.event.DocumentUpdateEvent;
import org.xwiki.observation.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexUpdater
extends AbstractXWikiRunnable
implements EventListener {
    private static final Log LOG = LogFactory.getLog(IndexUpdater.class);
    private static final String NAME = "lucene";
    private static final int EXIT_INTERVAL = 3000;
    private static final List<Event> EVENTS = Arrays.asList(new DocumentUpdateEvent(), new DocumentSaveEvent(), new DocumentDeleteEvent(), new ActionExecutionEvent("upload"));
    static final List<String> fields = new ArrayList<String>();
    private final LucenePlugin plugin;
    private final int indexingInterval;
    private final Directory directory;
    private final XWikiDocumentQueue queue = new XWikiDocumentQueue();
    private int indexingTimer = 0;
    private final int maxQueueSize;
    private volatile boolean exit = false;
    private Analyzer analyzer;

    IndexUpdater(Directory directory, int indexingInterval, int maxQueueSize, LucenePlugin plugin, XWikiContext context) {
        super("xwikicontext", context.clone());
        this.plugin = plugin;
        this.directory = directory;
        this.indexingInterval = indexingInterval;
        this.maxQueueSize = maxQueueSize;
    }

    private XWikiContext getContext() {
        return (XWikiContext)((Execution)Utils.getComponent(Execution.class)).getContext().getProperty("xwikicontext");
    }

    public void doExit() {
        this.exit = true;
    }

    public Directory getDirectory() {
        return this.directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInternal() {
        MDC.put((String)"url", (Object)"Lucene index updating thread");
        this.getContext().setDatabase(this.getContext().getMainXWiki());
        try {
            this.runMainLoop();
        }
        finally {
            MDC.remove((String)"url");
        }
    }

    private void runMainLoop() {
        while (!this.exit) {
            if (this.indexingTimer == 0) {
                this.indexingTimer = this.indexingInterval;
                this.updateIndex();
            }
            int sleepInterval = Math.min(3000, this.indexingTimer);
            this.indexingTimer -= sleepInterval;
            try {
                Thread.sleep(sleepInterval);
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"Error while sleeping", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIndex() {
        if (this.queue.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"IndexUpdater: queue empty, nothing to do");
            }
        } else {
            IndexWriter writer;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"IndexUpdater: documents in queue, start indexing");
            }
            XWikiContext context = this.getContext();
            context.getWiki().getStore().cleanUp(context);
            try {
                while (true) {
                    try {
                        writer = this.openWriter(false);
                    }
                    catch (CorruptIndexException e) {
                        this.plugin.handleCorruptIndex(context);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to open index", (Throwable)e);
                throw new RuntimeException(e);
            }
            try {
                int nb = 0;
                while (!this.queue.isEmpty()) {
                    IndexData data = this.queue.remove();
                    String id = data.getId();
                    try {
                        XWikiDocument doc = context.getWiki().getDocument(data.getFullName(), context);
                        if (data.getLanguage() != null && !data.getLanguage().equals("")) {
                            doc = doc.getTranslatedDocument(data.getLanguage(), context);
                        }
                        this.addToIndex(writer, data, doc, context);
                        ++nb;
                    }
                    catch (Throwable e) {
                        LOG.error((Object)("error indexing document " + id), e);
                    }
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("indexed " + nb + " docs to lucene index"));
                }
            }
            catch (Exception e) {
                LOG.error((Object)"error indexing documents", (Throwable)e);
            }
            finally {
                context.getWiki().getStore().cleanUp(context);
                try {
                    writer.optimize();
                    writer.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)"Failed to close writer.", (Throwable)e);
                }
            }
            this.plugin.openSearchers(context);
        }
    }

    protected IndexWriter openWriter(boolean create) throws IOException {
        while (true) {
            try {
                IndexWriter w = new IndexWriter(this.directory, this.analyzer, create, IndexWriter.MaxFieldLength.LIMITED);
                w.setUseCompoundFile(true);
                return w;
            }
            catch (LockObtainFailedException e) {
                try {
                    int s = new Random().nextInt(1000);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("failed to acquire lock, retrying in " + s + "ms ..."));
                    }
                    Thread.sleep(s);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    private void addToIndex(IndexWriter writer, IndexData data, XWikiDocument doc, XWikiContext context) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("addToIndex: " + data));
        }
        Document luceneDoc = new Document();
        data.addDataToLuceneDocument(luceneDoc, doc, context);
        for (Field field : luceneDoc.getFields()) {
            if (fields.contains(field.name())) continue;
            fields.add(field.name());
        }
        writer.updateDocument(new Term("_docid", data.getId()), luceneDoc);
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void cleanIndex() {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"trying to clear index for rebuilding");
        }
        try {
            this.openWriter(true).close();
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to clean index", (Throwable)e);
        }
    }

    public void add(XWikiDocument document, XWikiContext context) {
        this.queue.add(new DocumentData(document, context));
    }

    public void add(XWikiDocument document, XWikiAttachment attachment, XWikiContext context) {
        if (document != null && attachment != null && context != null) {
            this.queue.add(new AttachmentData(document, attachment, context));
        } else {
            LOG.error((Object)("invalid parameters given to add: " + document + ", " + attachment + ", " + context));
        }
    }

    public int addAttachmentsOfDocument(XWikiDocument document, XWikiContext context) {
        int retval = 0;
        List attachmentList = document.getAttachmentList();
        retval += attachmentList.size();
        for (XWikiAttachment attachment : attachmentList) {
            try {
                this.add(document, attachment, context);
            }
            catch (Exception e) {
                LOG.error((Object)("error retrieving attachment of document " + document.getFullName()), (Throwable)e);
            }
        }
        return retval;
    }

    public String getName() {
        return NAME;
    }

    public List<Event> getEvents() {
        return EVENTS;
    }

    public void onEvent(Event event, Object source, Object data) {
        XWikiDocument document = (XWikiDocument)source;
        XWikiContext context = (XWikiContext)data;
        try {
            if (event instanceof ActionExecutionEvent) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("upload action notification for doc " + document.getName()));
                }
                XWikiDocument basedoc = context.getWiki().getDocument(document.getFullName(), context);
                List attachments = basedoc.getAttachmentList();
                XWikiAttachment newestAttachment = null;
                for (XWikiAttachment attachment : attachments) {
                    if (newestAttachment != null && !attachment.getDate().after(newestAttachment.getDate())) continue;
                    newestAttachment = attachment;
                }
                this.add(basedoc, newestAttachment, context);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("notify from XWikiDocChangeNotificationInterface, event=" + event + ", doc=" + document));
                }
                this.add(document, context);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"error in notify", (Throwable)e);
        }
    }

    public long getQueueSize() {
        return this.queue.getSize();
    }

    public long getLuceneDocCount() {
        int n = -1;
        try {
            IndexWriter w = this.openWriter(false);
            n = w.numDocs();
            w.close();
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to get the number of documents in Lucene index writer", (Throwable)e);
        }
        return n;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }
}

