/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.lucene;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.api.XWiki;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.XWikiDefaultPlugin;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.lucene.IndexRebuilder;
import com.xpn.xwiki.plugin.lucene.IndexUpdater;
import com.xpn.xwiki.plugin.lucene.LucenePluginApi;
import com.xpn.xwiki.plugin.lucene.SearchResults;
import com.xpn.xwiki.web.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;

public class LucenePlugin
extends XWikiDefaultPlugin {
    public static final String DOCTYPE_WIKIPAGE = "wikipage";
    public static final String DOCTYPE_ATTACHMENT = "attachment";
    public static final String PROP_INDEX_DIR = "xwiki.plugins.lucene.indexdir";
    public static final String PROP_ANALYZER = "xwiki.plugins.lucene.analyzer";
    public static final String PROP_INDEXING_INTERVAL = "xwiki.plugins.lucene.indexinterval";
    public static final String PROP_MAX_QUEUE_SIZE = "xwiki.plugins.lucene.maxQueueSize";
    private static final String DEFAULT_ANALYZER = "org.apache.lucene.analysis.standard.StandardAnalyzer";
    private static final Log LOG = LogFactory.getLog(LucenePlugin.class);
    private Analyzer analyzer;
    private IndexUpdater indexUpdater;
    private Thread indexUpdaterThread;
    protected Properties config;
    private Searcher[] searchers;
    private String indexDirs;
    private IndexRebuilder indexRebuilder;

    public LucenePlugin(String name, String className, XWikiContext context) {
        super(name, className, context);
    }

    protected void finalize() throws Throwable {
        LOG.error((Object)"Lucene plugin will exit !");
        if (this.indexUpdater != null) {
            this.indexUpdater.doExit();
        }
        super.finalize();
    }

    public int rebuildIndex(XWikiContext context) {
        return this.indexRebuilder.startRebuildIndex(context);
    }

    public SearchResults getSearchResultsFromIndexes(String query, String myIndexDirs, String languages, XWikiContext context) throws Exception {
        Searcher[] mySearchers = this.createSearchers(myIndexDirs, context);
        SearchResults retval = this.search(query, (String)null, null, languages, mySearchers, context);
        LucenePlugin.closeSearchers(mySearchers);
        return retval;
    }

    public SearchResults getSearchResultsFromIndexes(String query, String[] sortFields, String myIndexDirs, String languages, XWikiContext context) throws Exception {
        Searcher[] mySearchers = this.createSearchers(myIndexDirs, context);
        SearchResults retval = this.search(query, sortFields, null, languages, mySearchers, context);
        LucenePlugin.closeSearchers(mySearchers);
        return retval;
    }

    public SearchResults getSearchResultsFromIndexes(String query, String sortField, String myIndexDirs, String languages, XWikiContext context) throws Exception {
        Searcher[] mySearchers = this.createSearchers(myIndexDirs, context);
        SearchResults retval = this.search(query, sortField, null, languages, mySearchers, context);
        LucenePlugin.closeSearchers(mySearchers);
        return retval;
    }

    public SearchResults getSearchResults(String query, String sortField, String virtualWikiNames, String languages, XWikiContext context) throws Exception {
        return this.search(query, sortField, virtualWikiNames, languages, this.searchers, context);
    }

    public SearchResults getSearchResults(String query, String[] sortField, String virtualWikiNames, String languages, XWikiContext context) throws Exception {
        return this.search(query, sortField, virtualWikiNames, languages, this.searchers, context);
    }

    private SearchResults search(String query, String sortField, String virtualWikiNames, String languages, Searcher[] indexes, XWikiContext context) throws IOException, ParseException {
        SortField sort = this.getSortField(sortField);
        return this.search(query, sort != null ? new Sort(sort) : null, virtualWikiNames, languages, indexes, context);
    }

    private SearchResults search(String query, String[] sortFields, String virtualWikiNames, String languages, Searcher[] indexes, XWikiContext context) throws IOException, ParseException {
        Object[] sorts = null;
        if (sortFields != null && sortFields.length > 0) {
            sorts = new SortField[sortFields.length];
            for (int i = 0; i < sortFields.length; ++i) {
                sorts[i] = this.getSortField(sortFields[i]);
            }
            int prevLength = -1;
            while (prevLength != sorts.length) {
                prevLength = sorts.length;
                sorts = (SortField[])ArrayUtils.removeElement((Object[])sorts, null);
            }
        }
        return this.search(query, sorts != null ? new Sort((SortField[])sorts) : null, virtualWikiNames, languages, indexes, context);
    }

    private SearchResults search(String query, Sort sort, String virtualWikiNames, String languages, Searcher[] indexes, XWikiContext context) throws IOException, ParseException {
        Hits hits;
        MultiSearcher searcher = new MultiSearcher((Searchable[])indexes);
        Query q = this.buildQuery(query, virtualWikiNames, languages);
        Hits hits2 = hits = sort == null ? searcher.search(q) : searcher.search(q, sort);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("query " + q + " returned " + hits.length() + " hits"));
        }
        return new SearchResults(hits, new XWiki(context.getWiki(), context), context);
    }

    private SortField getSortField(String sortField) {
        SortField sort = null;
        if (!StringUtils.isEmpty((String)sortField)) {
            sort = sortField.startsWith("-") ? new SortField(sortField.substring(1), true) : new SortField(sortField);
        }
        return sort;
    }

    private Query buildQuery(String query, String virtualWikiNames, String languages) throws ParseException {
        BooleanQuery bQuery = new BooleanQuery();
        Query parsedQuery = null;
        if (query.startsWith("PROP ")) {
            String property = query.substring(0, query.indexOf(":"));
            query = query.substring(query.indexOf(":") + 1, query.length());
            QueryParser qp = new QueryParser(Version.LUCENE_29, property, this.analyzer);
            parsedQuery = qp.parse(query);
            bQuery.add(parsedQuery, BooleanClause.Occur.MUST);
        } else if (query.startsWith("MULTI ")) {
            List<String> fieldList = IndexUpdater.fields;
            String[] fields = fieldList.toArray(new String[fieldList.size()]);
            BooleanClause.Occur[] flags = new BooleanClause.Occur[fields.length];
            for (int i = 0; i < flags.length; ++i) {
                flags[i] = BooleanClause.Occur.SHOULD;
            }
            parsedQuery = MultiFieldQueryParser.parse((Version)Version.LUCENE_29, (String)query, (String[])fields, (BooleanClause.Occur[])flags, (Analyzer)this.analyzer);
            bQuery.add(parsedQuery, BooleanClause.Occur.MUST);
        } else {
            QueryParser qp = new QueryParser(Version.LUCENE_29, "ft", this.analyzer);
            parsedQuery = qp.parse(query);
            bQuery.add(parsedQuery, BooleanClause.Occur.MUST);
        }
        if (virtualWikiNames != null && virtualWikiNames.length() > 0) {
            bQuery.add(this.buildOredTermQuery(virtualWikiNames, "wiki"), BooleanClause.Occur.MUST);
        }
        if (languages != null && languages.length() > 0) {
            bQuery.add(this.buildOredTermQuery(languages, "lang"), BooleanClause.Occur.SHOULD);
        }
        return bQuery;
    }

    private Query buildOredTermQuery(String values, String fieldname) {
        String[] valueArray = values.split("\\,");
        if (valueArray.length > 1) {
            BooleanQuery orQuery = new BooleanQuery();
            for (int i = 0; i < valueArray.length; ++i) {
                orQuery.add((Query)new TermQuery(new Term(fieldname, valueArray[i].trim())), BooleanClause.Occur.SHOULD);
            }
            return orQuery;
        }
        return new TermQuery(new Term(fieldname, valueArray[0]));
    }

    public synchronized void init(XWikiContext context) {
        FSDirectory directory;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Lucene plugin: in init");
        }
        this.config = context.getWiki().getConfig();
        this.indexDirs = this.config.getProperty(PROP_INDEX_DIR);
        if (StringUtils.isEmpty((String)this.indexDirs)) {
            File workDir = context.getWiki().getWorkSubdirectory("lucene", context);
            this.indexDirs = workDir.getAbsolutePath();
        }
        String indexDir = StringUtils.split((String)this.indexDirs, (String)",")[0];
        File f = new File(indexDir);
        try {
            if (!f.exists()) {
                f.mkdirs();
            }
            directory = FSDirectory.open((File)f);
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to open the index directory: ", (Throwable)e);
            throw new RuntimeException(e);
        }
        this.init((Directory)directory, context);
    }

    public void init(Directory directory, XWikiContext context) {
        int maxQueueSize;
        int indexingInterval;
        try {
            indexingInterval = 1000 * Integer.parseInt(this.config.getProperty(PROP_INDEXING_INTERVAL, "30"));
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)"Invalid indexing interval in configuration.");
            indexingInterval = 30000;
        }
        try {
            maxQueueSize = Integer.parseInt(this.config.getProperty(PROP_MAX_QUEUE_SIZE, "1000"));
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)"Invalid max queue size in configuration.");
            maxQueueSize = 1000;
        }
        IndexUpdater indexUpdater = new IndexUpdater(directory, indexingInterval, maxQueueSize, this, context);
        this.init(indexUpdater, context);
    }

    public void init(IndexUpdater indexUpdater, XWikiContext context) {
        Directory directory = indexUpdater.getDirectory();
        boolean needInitialRebuild = true;
        try {
            needInitialRebuild = !IndexReader.indexExists((Directory)directory);
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed to check if index exists: " + e));
        }
        IndexRebuilder indexRebuilder = new IndexRebuilder(indexUpdater, context, needInitialRebuild);
        this.init(indexUpdater, indexRebuilder, context);
    }

    public void init(IndexUpdater indexUpdater, IndexRebuilder indexRebuilder, XWikiContext context) {
        super.init(context);
        this.config = context.getWiki().getConfig();
        try {
            this.analyzer = (Analyzer)Class.forName(this.config.getProperty(PROP_ANALYZER, DEFAULT_ANALYZER)).newInstance();
        }
        catch (Exception e) {
            LOG.error((Object)"Error instantiating analyzer : ", (Throwable)e);
            LOG.warn((Object)"Using default analyzer class: org.apache.lucene.analysis.standard.StandardAnalyzer");
            try {
                this.analyzer = (Analyzer)Class.forName(DEFAULT_ANALYZER).newInstance();
            }
            catch (Exception e1) {
                throw new RuntimeException("Instantiation of default analyzer org.apache.lucene.analysis.standard.StandardAnalyzer failed", e1);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Assigning index updater: " + (Object)((Object)indexUpdater)));
        }
        if (this.indexDirs == null) {
            this.indexDirs = this.config.getProperty(PROP_INDEX_DIR);
            if (StringUtils.isEmpty((String)this.indexDirs)) {
                File workDir = context.getWiki().getWorkSubdirectory("lucene", context);
                this.indexDirs = workDir.getAbsolutePath();
            }
        }
        this.indexUpdater = indexUpdater;
        this.indexUpdater.setAnalyzer(this.analyzer);
        this.indexUpdaterThread = new Thread((Runnable)((Object)indexUpdater), "Lucene Index Updater");
        this.indexUpdaterThread.start();
        this.indexRebuilder = indexRebuilder;
        this.openSearchers(context);
        ObservationManager observationManager = (ObservationManager)Utils.getComponent(ObservationManager.class);
        if (observationManager.getListener(indexUpdater.getName()) == null) {
            observationManager.addListener((EventListener)indexUpdater);
        }
        LOG.debug((Object)"Lucene plugin initialized.");
    }

    public void flushCache(XWikiContext context) {
        if (this.indexUpdater != null) {
            ((ObservationManager)Utils.getComponent(ObservationManager.class)).removeListener(this.indexUpdater.getName());
            this.indexUpdater.doExit();
            try {
                this.indexUpdaterThread.join();
            }
            catch (InterruptedException ex) {
                LOG.warn((Object)"Error while waiting for indexUpdaterThread to die.", (Throwable)ex);
            }
            this.indexUpdater = null;
            this.indexUpdaterThread = null;
        }
        this.indexRebuilder = null;
        try {
            LucenePlugin.closeSearchers(this.searchers);
        }
        catch (IOException e) {
            LOG.warn((Object)"Cannot close searchers", (Throwable)e);
        }
        this.analyzer = null;
        this.init(context);
    }

    public String getName() {
        return "lucene";
    }

    public Api getPluginApi(XWikiPluginInterface plugin, XWikiContext context) {
        return new LucenePluginApi((LucenePlugin)plugin, context);
    }

    public Searcher[] createSearchers(String indexDirs, XWikiContext context) throws Exception {
        String[] dirs = StringUtils.split((String)indexDirs, (String)",");
        ArrayList<IndexSearcher> searchersList = new ArrayList<IndexSearcher>();
        block2: for (int i = 0; i < dirs.length; ++i) {
            while (true) {
                try {
                    if (!IndexReader.indexExists((String)dirs[i])) {
                        new IndexWriter(dirs[i], this.analyzer).close();
                    }
                    searchersList.add(new IndexSearcher(dirs[i], true));
                    continue block2;
                }
                catch (CorruptIndexException e) {
                    this.handleCorruptIndex(context);
                    continue;
                }
                break;
            }
        }
        return searchersList.toArray(new Searcher[searchersList.size()]);
    }

    protected synchronized void openSearchers(XWikiContext context) {
        try {
            LucenePlugin.closeSearchers(this.searchers);
            this.searchers = this.createSearchers(this.indexDirs, context);
        }
        catch (Exception e) {
            LOG.error((Object)("Error opening searchers for index dirs " + this.config.getProperty(PROP_INDEX_DIR)), (Throwable)e);
            throw new RuntimeException("Error opening searchers for index dirs " + this.config.getProperty(PROP_INDEX_DIR), e);
        }
    }

    protected static void closeSearchers(Searcher[] searchers) throws IOException {
        if (searchers != null) {
            for (int i = 0; i < searchers.length; ++i) {
                if (searchers[i] == null) continue;
                searchers[i].close();
            }
        }
    }

    public String getIndexDirs() {
        return this.indexDirs;
    }

    public long getQueueSize() {
        return this.indexUpdater.getQueueSize();
    }

    public void queueDocument(XWikiDocument doc, XWikiContext context) {
        this.indexUpdater.add(doc, context);
    }

    public void queueAttachment(XWikiDocument doc, XWikiAttachment attach, XWikiContext context) {
        this.indexUpdater.add(doc, attach, context);
    }

    public void queueAttachment(XWikiDocument doc, XWikiContext context) {
        this.indexUpdater.addAttachmentsOfDocument(doc, context);
    }

    public long getLuceneDocCount() {
        return this.indexUpdater.getLuceneDocCount();
    }

    void handleCorruptIndex(XWikiContext context) throws IOException {
        this.rebuildIndex(context);
    }
}

