/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.watchlist;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.StaticListClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.DocumentDeleteEvent;
import org.xwiki.observation.event.DocumentSaveEvent;
import org.xwiki.observation.event.DocumentUpdateEvent;
import org.xwiki.observation.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WatchListStore
implements EventListener {
    public static final String WATCHLIST_ELEMENT_SEP = ",";
    public static final String WIKI_SPACE_SEP = ":";
    public static final String SPACE_PAGE_SEP = ".";
    public static final String SCHEDULER_SPACE = "Scheduler";
    private static final String LISTENER_NAME = "watchliststore";
    private static final List<Event> LISTENER_EVENTS = new ArrayList<Event>(){
        {
            this.add(new DocumentSaveEvent());
            this.add(new DocumentUpdateEvent());
            this.add(new DocumentDeleteEvent());
        }
    };
    private static final Log LOG = LogFactory.getLog(WatchListStore.class);
    private static final String WATCHLIST_CLASS = "XWiki.WatchListClass";
    private static final String WATCHLIST_CLASS_INTERVAL_PROP = "interval";
    private static final String WATCHLIST_CLASS_WIKIS_PROP = "wikis";
    private static final String WATCHLIST_CLASS_SPACES_PROP = "spaces";
    private static final String WATCHLIST_CLASS_DOCUMENTS_PROP = "documents";
    private static final String WATCHLIST_CLASS_USERS_PROP = "users";
    private List<String> jobDocumentNames;
    private Map<String, List<String>> subscribers = new HashMap<String, List<String>>();

    private boolean initWatchListClassProperties(XWikiDocument watchListClass, XWikiContext context) throws XWikiException {
        boolean needsUpdate = false;
        BaseClass bclass = watchListClass.getxWikiClass();
        bclass.setName(WATCHLIST_CLASS);
        needsUpdate |= bclass.addStaticListField(WATCHLIST_CLASS_INTERVAL_PROP, "Email notifications interval", "");
        StaticListClass intervalClass = (StaticListClass)bclass.get(WATCHLIST_CLASS_INTERVAL_PROP);
        List intervalValues = intervalClass.getList(context);
        ArrayList<String> newInterval = new ArrayList<String>();
        boolean intervalNeedsUpdate = false;
        for (String jobName : this.jobDocumentNames) {
            if (newInterval.contains(jobName)) continue;
            newInterval.add(jobName);
            intervalNeedsUpdate = true;
        }
        for (String jobName : intervalValues) {
            if (newInterval.contains(jobName)) continue;
            intervalNeedsUpdate = true;
        }
        if (intervalNeedsUpdate) {
            intervalClass.setValues(StringUtils.join(newInterval, (String)"|"));
            needsUpdate = true;
        }
        needsUpdate |= bclass.addTextAreaField(WATCHLIST_CLASS_WIKIS_PROP, "Wiki list", 80, 5);
        needsUpdate |= bclass.addTextAreaField(WATCHLIST_CLASS_SPACES_PROP, "Space list", 80, 5);
        needsUpdate |= bclass.addTextAreaField(WATCHLIST_CLASS_DOCUMENTS_PROP, "Document list", 80, 5);
        return needsUpdate |= bclass.addTextAreaField(WATCHLIST_CLASS_USERS_PROP, "User list", 80, 5);
    }

    private void initWatchListClass(XWikiContext context) throws XWikiException {
        XWikiDocument doc;
        boolean needsUpdate = false;
        try {
            doc = context.getWiki().getDocument(WATCHLIST_CLASS, context);
        }
        catch (Exception e) {
            doc = new XWikiDocument();
            String[] spaceAndName = WATCHLIST_CLASS.split(SPACE_PAGE_SEP);
            doc.setSpace(spaceAndName[0]);
            doc.setName(spaceAndName[1]);
            needsUpdate = true;
        }
        needsUpdate = this.initWatchListClassProperties(doc, context);
        if (StringUtils.isBlank((String)doc.getCreator())) {
            needsUpdate = true;
            doc.setCreator("superadmin");
        }
        if (StringUtils.isBlank((String)doc.getAuthor())) {
            needsUpdate = true;
            doc.setAuthor(doc.getCreator());
        }
        if (StringUtils.isBlank((String)doc.getParent())) {
            needsUpdate = true;
            doc.setParent("XWiki.XWikiClasses");
        }
        if (StringUtils.isBlank((String)doc.getTitle())) {
            needsUpdate = true;
            doc.setTitle("XWiki WatchList Notification Rules Class");
        }
        if (StringUtils.isBlank((String)doc.getContent()) || !XWikiDocument.XWIKI20_SYNTAXID.equals(doc.getSyntaxId())) {
            needsUpdate = true;
            doc.setContent("{{include document=\"XWiki.ClassSheet\" /}}");
            doc.setSyntaxId(XWikiDocument.XWIKI20_SYNTAXID);
        }
        if (needsUpdate) {
            context.getWiki().saveDocument(doc, "", true, context);
        }
    }

    private void initSubscribersCache(String jobName, XWikiContext context) {
        ArrayList<Object> queryParams = new ArrayList<Object>();
        queryParams.add(WATCHLIST_CLASS);
        queryParams.add(jobName);
        List<String> subscribersForJob = this.globalSearchDocuments(", BaseObject as obj, StringProperty as prop where doc.fullName=obj.name and obj.className=? and obj.id=prop.id.id and prop.value=?", 0, 0, queryParams, context);
        this.subscribers.put(jobName, subscribersForJob);
    }

    private void destroySubscribersCache(String jobName, XWikiContext context) {
        this.subscribers.remove(jobName);
    }

    public void init(XWikiContext context) throws XWikiException {
        this.jobDocumentNames = context.getWiki().getStore().searchDocumentsNames(", BaseObject as obj where doc.fullName=obj.name and obj.className='XWiki.WatchListJobClass'", context);
        this.initWatchListClass(context);
        for (String jobDocumentName : this.jobDocumentNames) {
            this.initSubscribersCache(jobDocumentName, context);
        }
    }

    public void virtualInit(XWikiContext context) throws XWikiException {
        this.initWatchListClass(context);
    }

    public List<String> getSubscribersForJob(String jobId) {
        List<String> result = this.subscribers.get(jobId);
        if (result == null) {
            return new ArrayList<String>();
        }
        return result;
    }

    private void addSubscriberForJob(String jobId, String user) {
        List<String> subForJob = this.subscribers.get(jobId);
        if (subForJob != null && !subForJob.contains(user)) {
            subForJob.add(user);
        }
    }

    private void removeSubscriberForJob(String jobId, String user) {
        List<String> subForJob = this.subscribers.get(jobId);
        if (subForJob != null && subForJob.contains(user)) {
            subForJob.remove(user);
        }
    }

    public List<String> getWatchedElements(String user, ElementType type, XWikiContext context) throws XWikiException {
        BaseObject watchListObject = this.getWatchListObject(user, context);
        String watchedItems = watchListObject.getLargeStringValue(this.getWatchListClassPropertyForType(type)).trim();
        ArrayList<String> elements = new ArrayList<String>();
        elements.addAll(Arrays.asList(watchedItems.split(WATCHLIST_ELEMENT_SEP)));
        return elements;
    }

    public boolean isWatched(String element, String user, ElementType type, XWikiContext context) throws XWikiException {
        return this.getWatchedElements(user, type, context).contains(element);
    }

    private String getWatchListClassPropertyForType(ElementType type) {
        if (ElementType.WIKI.equals((Object)type)) {
            return WATCHLIST_CLASS_WIKIS_PROP;
        }
        if (ElementType.SPACE.equals((Object)type)) {
            return WATCHLIST_CLASS_SPACES_PROP;
        }
        if (ElementType.DOCUMENT.equals((Object)type)) {
            return WATCHLIST_CLASS_DOCUMENTS_PROP;
        }
        if (ElementType.USER.equals((Object)type)) {
            return WATCHLIST_CLASS_USERS_PROP;
        }
        return "";
    }

    public boolean addWatchedElement(String user, String newWatchedElement, ElementType type, XWikiContext context) throws XWikiException {
        String elementToWatch = newWatchedElement;
        if (!ElementType.WIKI.equals((Object)type) && !newWatchedElement.contains(WIKI_SPACE_SEP)) {
            elementToWatch = context.getDatabase() + WIKI_SPACE_SEP + newWatchedElement;
        }
        if (this.isWatched(elementToWatch, user, type, context)) {
            return false;
        }
        List<String> watchedElements = this.getWatchedElements(user, type, context);
        watchedElements.add(elementToWatch);
        this.setWatchListElementsProperty(user, type, watchedElements, context);
        return true;
    }

    public boolean removeWatchedElement(String user, String watchedElement, ElementType type, XWikiContext context) throws XWikiException {
        String elementToRemove = watchedElement;
        if (!ElementType.WIKI.equals((Object)type) && !watchedElement.contains(WIKI_SPACE_SEP)) {
            elementToRemove = context.getDatabase() + WIKI_SPACE_SEP + watchedElement;
        }
        if (!this.isWatched(elementToRemove, user, type, context)) {
            return false;
        }
        List<String> watchedElements = this.getWatchedElements(user, type, context);
        watchedElements.remove(elementToRemove);
        this.setWatchListElementsProperty(user, type, watchedElements, context);
        return true;
    }

    public BaseObject createWatchListObject(String user, XWikiContext context) throws XWikiException {
        XWikiDocument userDocument = context.getWiki().getDocument(user, context);
        int nb = userDocument.createNewObject(WATCHLIST_CLASS, context);
        BaseObject wObj = userDocument.getObject(WATCHLIST_CLASS, nb);
        context.getWiki().saveDocument(userDocument, context.getMessageTool().get("watchlist.create.object"), true, context);
        return wObj;
    }

    public BaseObject getWatchListObject(String user, XWikiContext context) throws XWikiException {
        XWikiDocument userDocument = context.getWiki().getDocument(user, context);
        BaseObject obj = userDocument.getObject(WATCHLIST_CLASS);
        if (obj == null) {
            obj = this.createWatchListObject(user, context);
        }
        return obj;
    }

    private void setWatchListElementsProperty(String user, ElementType type, List<String> elements, XWikiContext context) throws XWikiException {
        XWikiDocument userDocument = context.getWiki().getDocument(user, context);
        userDocument.setLargeStringValue(WATCHLIST_CLASS, this.getWatchListClassPropertyForType(type), StringUtils.join(elements, (String)WATCHLIST_ELEMENT_SEP));
        userDocument.isMinorEdit();
        context.getWiki().saveDocument(userDocument, context.getMessageTool().get("watchlist.save.object"), true, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> globalSearchDocuments(String request, int nb, int start, List<Object> values, XWikiContext context) {
        List<String> wikiServers = new ArrayList<String>();
        ArrayList<String> results = new ArrayList<String>();
        if (context.getWiki().isVirtualMode()) {
            try {
                wikiServers = context.getWiki().getVirtualWikisDatabaseNames(context);
                if (!wikiServers.contains(context.getMainXWiki())) {
                    wikiServers.add(context.getMainXWiki());
                }
            }
            catch (Exception e) {
                LOG.error((Object)"error getting list of wiki servers", (Throwable)e);
            }
        } else {
            wikiServers = new ArrayList();
            wikiServers.add(context.getMainXWiki());
        }
        String oriDatabase = context.getDatabase();
        try {
            for (String wiki : wikiServers) {
                String wikiPrefix = wiki + WIKI_SPACE_SEP;
                context.setDatabase(wiki);
                try {
                    List upDocsInWiki = context.getWiki().getStore().searchDocumentsNames(request, 0, 0, values, context);
                    Iterator it = upDocsInWiki.iterator();
                    while (it.hasNext()) {
                        results.add(wikiPrefix + (String)it.next());
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("error getting list of documents in the wiki : " + wiki), (Throwable)e);
                }
            }
        }
        finally {
            context.setDatabase(oriDatabase);
        }
        return results;
    }

    private void watchListJobObjectsEventHandler(XWikiDocument originalDoc, XWikiDocument currentDoc, XWikiContext context) {
        boolean reinitWatchListClass = false;
        BaseObject originalJob = originalDoc.getObject("XWiki.WatchListJobClass");
        BaseObject currentJob = currentDoc.getObject("XWiki.WatchListJobClass");
        if (originalJob != null && currentJob == null && this.jobDocumentNames.contains(originalDoc.getFullName())) {
            int index = this.jobDocumentNames.indexOf(originalDoc.getFullName());
            this.jobDocumentNames.remove(index);
            this.destroySubscribersCache(originalDoc.getFullName(), context);
            reinitWatchListClass = true;
        }
        if (originalJob == null && currentJob != null) {
            this.jobDocumentNames.add(currentDoc.getFullName());
            this.initSubscribersCache(currentDoc.getFullName(), context);
            reinitWatchListClass = true;
        }
        if (reinitWatchListClass) {
            try {
                this.initWatchListClass(context);
            }
            catch (XWikiException e) {
                // empty catch block
            }
        }
    }

    private void watchListObjectsEventHandler(XWikiDocument originalDoc, XWikiDocument currentDoc, XWikiContext context) {
        String wiki = context.getDatabase();
        BaseObject originalWatchListObj = originalDoc.getObject(WATCHLIST_CLASS);
        BaseObject currentWatchListObj = currentDoc.getObject(WATCHLIST_CLASS);
        if (originalWatchListObj != null) {
            String oriInterval = originalWatchListObj.getStringValue(WATCHLIST_CLASS_INTERVAL_PROP);
            if (currentWatchListObj == null) {
                this.removeSubscriberForJob(oriInterval, wiki + WIKI_SPACE_SEP + originalDoc.getFullName());
                return;
            }
            if (originalWatchListObj != null && currentDoc.getObject(WATCHLIST_CLASS) == null) {
                this.removeSubscriberForJob(oriInterval, wiki + WIKI_SPACE_SEP + originalDoc.getFullName());
                return;
            }
            String newInterval = currentWatchListObj.getStringValue(WATCHLIST_CLASS_INTERVAL_PROP);
            if (!newInterval.equals(oriInterval)) {
                this.removeSubscriberForJob(oriInterval, wiki + WIKI_SPACE_SEP + originalDoc.getFullName());
                this.addSubscriberForJob(newInterval, wiki + WIKI_SPACE_SEP + currentDoc.getFullName());
            }
        }
        if ((originalWatchListObj == null || originalDoc == null) && currentWatchListObj != null) {
            String newInterval = currentWatchListObj.getStringValue(WATCHLIST_CLASS_INTERVAL_PROP);
            this.addSubscriberForJob(newInterval, wiki + WIKI_SPACE_SEP + currentDoc.getFullName());
        }
    }

    public void onEvent(Event event, Object source, Object data) {
        XWikiDocument currentDoc = (XWikiDocument)source;
        XWikiDocument originalDoc = currentDoc.getOriginalDocument();
        XWikiContext context = (XWikiContext)data;
        this.watchListJobObjectsEventHandler(originalDoc, currentDoc, context);
        this.watchListObjectsEventHandler(originalDoc, currentDoc, context);
    }

    public List<Event> getEvents() {
        return LISTENER_EVENTS;
    }

    public String getName() {
        return LISTENER_NAME;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ElementType {
        WIKI,
        SPACE,
        DOCUMENT,
        USER;

    }
}

