/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.watchlist;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Context;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.Object;
import com.xpn.xwiki.api.Util;
import com.xpn.xwiki.api.XWiki;
import com.xpn.xwiki.plugin.mailsender.MailSenderPlugin;
import com.xpn.xwiki.plugin.watchlist.WatchListEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.velocity.VelocityContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WatchListNotifier {
    public static final String DEFAULT_EMAIL_TEMPLATE = "XWiki.WatchListMessage";
    public static final String XWIKI_USER_CLASS = "XWiki.XWikiUsers";
    public static final String XWIKI_USER_CLASS_FIRST_NAME_PROP = "first_name";
    public static final String XWIKI_USER_CLASS_LAST_NAME_PROP = "last_name";
    private static final String XWIKI_USER_CLASS_EMAIL_PROP = "email";

    public void sendEmailNotification(String subscriber, List<WatchListEvent> events, String emailTemplate, Date previousFireTime, XWikiContext context) throws XWikiException {
        Document subscriberDocument = context.getWiki().getDocument(subscriber, context).newDocument(context);
        Object userObj = subscriberDocument.getObject(XWIKI_USER_CLASS);
        String emailAddr = (String)userObj.getProperty(XWIKI_USER_CLASS_EMAIL_PROP).getValue();
        if (emailAddr == null || emailAddr.length() == 0 || emailAddr.indexOf("@") < 0) {
            return;
        }
        ArrayList<String> modifiedDocuments = new ArrayList<String>();
        for (WatchListEvent event : events) {
            if (modifiedDocuments.contains(event.getPrefixedFullName())) continue;
            modifiedDocuments.add(event.getPrefixedFullName());
        }
        VelocityContext vcontext = new VelocityContext();
        vcontext.put(XWIKI_USER_CLASS_FIRST_NAME_PROP, userObj.getProperty(XWIKI_USER_CLASS_FIRST_NAME_PROP).getValue());
        vcontext.put(XWIKI_USER_CLASS_LAST_NAME_PROP, userObj.getProperty(XWIKI_USER_CLASS_LAST_NAME_PROP).getValue());
        vcontext.put("events", events);
        vcontext.put("xwiki", (java.lang.Object)new XWiki(context.getWiki(), context));
        vcontext.put("util", (java.lang.Object)new Util(context.getWiki(), context));
        vcontext.put("msg", (java.lang.Object)context.getMessageTool());
        vcontext.put("modifiedDocuments", modifiedDocuments);
        vcontext.put("previousFireTime", (java.lang.Object)previousFireTime);
        vcontext.put("context", (java.lang.Object)new Context(context));
        String language = context.getWiki().getXWikiPreference("default_language", "en", context);
        MailSenderPlugin emailService = (MailSenderPlugin)context.getWiki().getPlugin("mailsender", context);
        if (emailService == null) {
            return;
        }
        String sender = context.getWiki().getXWikiPreference("admin_email", "mailer@xwiki.localdomain.com", context);
        String template = "";
        template = context.getWiki().exists(emailTemplate, context) ? emailTemplate : (context.getWiki().exists(DEFAULT_EMAIL_TEMPLATE, context) ? DEFAULT_EMAIL_TEMPLATE : context.getMainXWiki() + ":" + DEFAULT_EMAIL_TEMPLATE);
        emailService.sendMailFromTemplate(template, sender, emailAddr, null, null, language, vcontext, context);
    }
}

