/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.globalsearch;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.applicationmanager.core.plugin.XWikiPluginMessageTool;
import com.xpn.xwiki.plugin.globalsearch.tools.GlobalSearchQuery;
import com.xpn.xwiki.plugin.globalsearch.tools.GlobalSearchResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GlobalSearch {
    protected static final Log LOG = LogFactory.getLog(GlobalSearch.class);
    private static final String SELECT_KEYWORD = "select";
    private static final String SELECT_DISTINCT_KEYWORD = "select distinct";
    private static final String FROM_KEYWORD = "from";
    private static final String WHERE_KEYWORD = "where";
    private static final String ORDER_KEYWORD = "order by";
    private static final String ORDER_DESC = "desc";
    private static final String HQL_DOC_SPACE = "doc.space";
    private static final String HQL_DOC_NAME = "doc.name";
    private static final String SEARCHDOC_INITIAL_SELECT = "select distinct doc.space, doc.name";
    private static final String SEARCHDOC_INITIAL_SELECT_LANG = "select distinct doc.space, doc.name, doc.language";
    private static final String SEARCHDOC_INITIAL_FROM = " from XWikiDocument as doc";
    private static final String FIELD_SEPARATOR = ",";
    private XWikiPluginMessageTool messageTool;

    GlobalSearch(XWikiPluginMessageTool messageTool) {
        this.messageTool = messageTool;
    }

    private Collection<String> getAllWikiNameList(XWikiContext context) throws XWikiException {
        List wikiNames = context.getWiki().getVirtualWikisDatabaseNames(context);
        if (!wikiNames.contains(context.getMainXWiki())) {
            wikiNames.add(context.getMainXWiki());
        }
        return wikiNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<GlobalSearchResult> search(GlobalSearchQuery query, XWikiContext context) throws XWikiException {
        Collection<String> wikiNameList;
        List<GlobalSearchResult> resultList = Collections.emptyList();
        List<String> selectColumns = this.parseSelectColumns(query.getHql());
        List<Object[]> orderColumns = this.parseOrderColumns(query.getHql());
        if (context.getWiki().isVirtualMode()) {
            wikiNameList = query.getWikiNameList();
            if (wikiNameList.isEmpty()) {
                wikiNameList = this.getAllWikiNameList(context);
            }
        } else {
            wikiNameList = Collections.singletonList(context.getMainXWiki());
        }
        int max = query.getMax() > 0 ? query.getMax() + (query.getStart() > 0 ? query.getStart() : 0) : 0;
        String database = context.getDatabase();
        try {
            resultList = new LinkedList();
            for (String wikiName : wikiNameList) {
                context.setDatabase(wikiName);
                List resultsTmp = context.getWiki().getStore().search(query.getHql(), max, 0, query.getParameterList(), context);
                this.insertResults(wikiName, resultList, resultsTmp, query, selectColumns, orderColumns, context);
            }
        }
        finally {
            context.setDatabase(database);
        }
        if (resultList.size() > max || query.getStart() > 0) {
            resultList = resultList.subList(query.getStart() > 0 ? query.getStart() : 0, resultList.size() > max ? max : resultList.size());
        }
        return resultList;
    }

    private void insertResults(String wikiName, List<GlobalSearchResult> sortedList, Collection<?> list, GlobalSearchQuery query, List<String> selectColumns, List<Object[]> orderColumns, XWikiContext context) {
        boolean sort = !sortedList.isEmpty();
        for (Object item : list) {
            Object[] objects = (Object[])item;
            GlobalSearchResult result = new GlobalSearchResult(wikiName, selectColumns, objects);
            if (sort) {
                this.insertResult(sortedList, result, query, selectColumns, orderColumns, context);
                continue;
            }
            sortedList.add(result);
        }
    }

    private void insertResult(List<GlobalSearchResult> sortedList, GlobalSearchResult result, GlobalSearchQuery query, List<String> selectColumns, List<Object[]> orderColumns, XWikiContext context) {
        GlobalSearchResult sortedResult;
        int index;
        int max = query.getMax() > 0 ? query.getMax() + (query.getStart() > 0 ? query.getStart() : 0) : -1;
        Iterator<GlobalSearchResult> itSorted = sortedList.iterator();
        for (index = 0; itSorted.hasNext() && (max <= 0 || index < max) && this.compare(sortedResult = itSorted.next(), result, orderColumns) <= 0; ++index) {
        }
        if (max <= 0 || index < max) {
            sortedList.add(index, result);
        }
    }

    private int compare(GlobalSearchResult result1, GlobalSearchResult result2, List<Object[]> orderColumns) {
        for (Object[] orderField : orderColumns) {
            int result = this.compare(result1, result2, orderField);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    private int compare(GlobalSearchResult result1, GlobalSearchResult result2, Object[] orderField) {
        int result = 0;
        String fieldName = (String)orderField[0];
        boolean fieldAsc = (Boolean)orderField[1];
        Object value1 = result1.get(fieldName);
        Object value2 = result2.get(fieldName);
        if (value1 instanceof String) {
            result = ((String)value1).compareToIgnoreCase((String)value2);
        } else if (value1 instanceof Comparable) {
            result = ((Comparable)value1).compareTo(value2);
        }
        return fieldAsc ? result : -result;
    }

    private List<String> parseSelectColumns(String hql) {
        ArrayList<String> columnList = new ArrayList<String>();
        int selectEnd = 0;
        int selectIndex = hql.toLowerCase().indexOf(SELECT_DISTINCT_KEYWORD);
        if (selectIndex < 0) {
            selectIndex = hql.toLowerCase().indexOf(SELECT_KEYWORD);
            if (selectIndex < 0) {
                selectIndex = 0;
            } else {
                selectEnd = SELECT_KEYWORD.length();
            }
        } else {
            selectEnd = SELECT_DISTINCT_KEYWORD.length();
        }
        int fromIndex = hql.toLowerCase().indexOf(FROM_KEYWORD);
        if (fromIndex >= 0) {
            String selectContent = hql.substring(selectIndex + selectEnd + 1, fromIndex);
            String[] columnsTable = selectContent.split(FIELD_SEPARATOR);
            for (int i = 0; i < columnsTable.length; ++i) {
                String[] column = columnsTable[i].trim().split("\\s");
                String columnName = column[0];
                columnList.add(columnName);
            }
        }
        return columnList;
    }

    private List<Object[]> parseOrderColumns(String hql) {
        ArrayList<Object[]> columnList = new ArrayList<Object[]>();
        int orderIndex = hql.toLowerCase().lastIndexOf(ORDER_KEYWORD);
        if (orderIndex >= 0) {
            String orderContent = hql.substring(orderIndex + ORDER_KEYWORD.length() + 1);
            String[] columnsTable = orderContent.split(FIELD_SEPARATOR);
            for (int i = 0; i < columnsTable.length; ++i) {
                String orderField = columnsTable[i];
                String[] orderFieldTable = orderContent.split("\\s+");
                orderField = orderFieldTable[0];
                Boolean asc = Boolean.TRUE;
                if (orderFieldTable.length > 1 && orderFieldTable[1].trim().toLowerCase().equals(ORDER_DESC)) {
                    asc = Boolean.FALSE;
                }
                columnList.add(new Object[]{orderField.trim(), asc});
            }
        }
        return columnList;
    }

    protected String createSearchDocumentsHQLQuery(String queryPrefix, String whereSQL) {
        StringBuffer hql = new StringBuffer(queryPrefix);
        String normalizedWhereSQL = whereSQL == null ? "" : whereSQL.trim();
        List<Object[]> orderColumns = this.parseOrderColumns(normalizedWhereSQL);
        for (Object[] orderField : orderColumns) {
            if (orderField[0].equals(HQL_DOC_SPACE) || orderField[0].equals(HQL_DOC_NAME)) continue;
            hql.append(FIELD_SEPARATOR);
            hql.append(orderField[0]);
        }
        hql.append(SEARCHDOC_INITIAL_FROM);
        if (normalizedWhereSQL.length() != 0) {
            if (!normalizedWhereSQL.startsWith(WHERE_KEYWORD) && !normalizedWhereSQL.startsWith(FIELD_SEPARATOR)) {
                hql.append(" ");
                hql.append(WHERE_KEYWORD);
                hql.append(" ");
            } else {
                hql.append(" ");
            }
            hql.append(normalizedWhereSQL);
        }
        return hql.toString();
    }

    private Collection<GlobalSearchResult> searchDocumentsNamesInfos(GlobalSearchQuery query, boolean distinctbylanguage, boolean customMapping, boolean checkRight, XWikiContext context) throws XWikiException {
        if (!query.getHql().toLowerCase().startsWith(SELECT_KEYWORD)) {
            String select = distinctbylanguage ? SEARCHDOC_INITIAL_SELECT_LANG : SEARCHDOC_INITIAL_SELECT;
            query.setHql(this.createSearchDocumentsHQLQuery(select, query.getHql()));
        }
        return this.search(query, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<XWikiDocument> searchDocuments(GlobalSearchQuery query, boolean distinctbylanguage, boolean customMapping, boolean checkRight, XWikiContext context) throws XWikiException {
        Collection<GlobalSearchResult> results = this.searchDocumentsNamesInfos(query, distinctbylanguage, customMapping, checkRight, context);
        ArrayList<XWikiDocument> documents = new ArrayList<XWikiDocument>(results.size());
        String database = context.getDatabase();
        try {
            for (GlobalSearchResult result : results) {
                XWikiDocument doc = new XWikiDocument();
                doc.setSpace((String)result.get(HQL_DOC_SPACE));
                doc.setName((String)result.get(HQL_DOC_NAME));
                context.setDatabase(result.getWikiName());
                doc = context.getWiki().getStore().loadXWikiDoc(doc, context);
                if (checkRight && !context.getWiki().getRightService().checkAccess("view", doc, context)) continue;
                documents.add(doc);
            }
        }
        finally {
            context.setDatabase(database);
        }
        return documents;
    }

    public Collection<String> searchDocumentsNames(GlobalSearchQuery query, boolean distinctbylanguage, boolean customMapping, boolean checkRight, XWikiContext context) throws XWikiException {
        Collection<GlobalSearchResult> results = this.searchDocumentsNamesInfos(query, distinctbylanguage, customMapping, checkRight, context);
        ArrayList<String> documentsNames = new ArrayList<String>(results.size());
        for (GlobalSearchResult result : results) {
            documentsNames.add(result.getWikiName() + ":" + result.get(HQL_DOC_SPACE) + "." + result.get(HQL_DOC_NAME));
        }
        return documentsNames;
    }
}

