/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.wikimanager;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.plugin.PluginApi;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.applicationmanager.core.api.XWikiExceptionApi;
import com.xpn.xwiki.plugin.applicationmanager.core.plugin.XWikiPluginMessageTool;
import com.xpn.xwiki.plugin.globalsearch.GlobalSearchPluginApi;
import com.xpn.xwiki.plugin.wikimanager.WikiManager;
import com.xpn.xwiki.plugin.wikimanager.WikiManagerException;
import com.xpn.xwiki.plugin.wikimanager.WikiManagerMessageTool;
import com.xpn.xwiki.plugin.wikimanager.WikiManagerPlugin;
import com.xpn.xwiki.plugin.wikimanager.doc.Wiki;
import com.xpn.xwiki.plugin.wikimanager.doc.XWikiServer;
import com.xpn.xwiki.plugin.wikimanager.doc.XWikiServerClass;
import com.xpn.xwiki.web.XWikiMessageTool;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiManagerPluginApi
extends PluginApi<WikiManagerPlugin> {
    public static final String CONTEXT_LASTERRORCODE = "lasterrorcode";
    public static final String CONTEXT_LASTEXCEPTION = "lastexception";
    protected static final Log LOG = LogFactory.getLog(WikiManagerPluginApi.class);
    private XWikiExceptionApi defaultException;
    private GlobalSearchPluginApi searchApi;
    private XWikiPluginMessageTool messageTool;

    public WikiManagerPluginApi(WikiManagerPlugin plugin, XWikiContext context) {
        super((XWikiPluginInterface)plugin, context);
        this.defaultException = new XWikiExceptionApi((XWikiException)((Object)WikiManagerException.getDefaultException()), this.context);
        Locale locale = (Locale)context.get((Object)"locale");
        this.messageTool = new WikiManagerMessageTool(locale, plugin, context);
        context.put((Object)"wikimanagermessagetool", (Object)this.messageTool);
        this.searchApi = plugin.getGlobalSearchApiPlugin(context);
    }

    public XWikiExceptionApi getDefaultException() {
        return this.defaultException;
    }

    public XWikiMessageTool getMessageTool() {
        return this.messageTool;
    }

    public GlobalSearchPluginApi getSearchApi() {
        return this.searchApi;
    }

    public void logError(String errorMessage, XWikiException e) {
        LOG.error((Object)errorMessage, (Throwable)e);
        this.context.put((Object)CONTEXT_LASTERRORCODE, (Object)e.getCode());
        this.context.put((Object)CONTEXT_LASTEXCEPTION, (Object)new XWikiExceptionApi(e, this.context));
    }

    public int createNewWiki(String wikiname, String templateWiki, String pkgName, XWikiServer wikiXObjectDocument, boolean failOnExist) throws XWikiException {
        if (!this.hasAdminRights()) {
            return 9001;
        }
        int returncode = -1;
        try {
            if (wikiname == null || wikiname.trim().equals("")) {
                throw new WikiManagerException(50036, this.messageTool.get("wikimanager.plugin.error.wikinameforbidden", wikiname));
            }
            wikiXObjectDocument.setWikiName(wikiname);
            String realTemplateWikiName = templateWiki == null || templateWiki.trim().length() == 0 ? null : templateWiki;
            String realPkgName = pkgName == null || pkgName.trim().length() == 0 ? null : pkgName;
            String comment = "wikimanager.plugin.comment.createwiki";
            WikiManager.getInstance().createNewWiki(wikiXObjectDocument, failOnExist, realTemplateWikiName, realPkgName, comment, this.context);
        }
        catch (WikiManagerException e) {
            this.logError(this.messageTool.get("wikimanager.plugin.log.wikicreation", wikiXObjectDocument.toString()), (XWikiException)((Object)e));
            returncode = e.getCode();
        }
        return returncode;
    }

    public int deleteWiki(String wikiName, boolean deleteDatabase) throws XWikiException {
        int returncode = -1;
        try {
            if (!this.hasAdminRights()) {
                throw new WikiManagerException(9001, this.messageTool.get("wikimanager.plugin.error.righttodeletewiki", wikiName));
            }
            WikiManager.getInstance().deleteWiki(wikiName, deleteDatabase, this.context);
        }
        catch (WikiManagerException e) {
            this.logError(this.messageTool.get("wikimanager.plugin.log.wikideletion", wikiName), (XWikiException)((Object)e));
            returncode = e.getCode();
        }
        return returncode;
    }

    public int deleteWiki(String wikiName) throws XWikiException {
        return this.deleteWiki(wikiName, true);
    }

    @Deprecated
    public int deleteWiki(String wikiName, int objectId) throws XWikiException {
        return this.deleteWikiAlias(wikiName, objectId);
    }

    public int deleteWikiAlias(String wikiName, int objectId) throws XWikiException {
        int returncode = -1;
        try {
            if (!this.hasAdminRights()) {
                throw new WikiManagerException(9001, this.messageTool.get("wikimanager.plugin.error.righttodeletewiki", wikiName));
            }
            WikiManager.getInstance().deleteWikiAlias(wikiName, objectId, this.context);
        }
        catch (WikiManagerException e) {
            this.logError(this.messageTool.get("wikimanager.plugin.log.wikideletion", wikiName), (XWikiException)((Object)e));
            returncode = e.getCode();
        }
        return returncode;
    }

    public Wiki getWikiFromName(String wikiName) throws XWikiException {
        Wiki doc = null;
        try {
            doc = WikiManager.getInstance().getWikiFromName(wikiName, this.context);
        }
        catch (WikiManagerException e) {
            this.logError(this.messageTool.get("wikimanager.plugin.log.wikiget", wikiName), (XWikiException)((Object)e));
        }
        return doc;
    }

    public List<Wiki> getAllWikis() throws XWikiException {
        List<Wiki> wikiList = Collections.emptyList();
        try {
            wikiList = WikiManager.getInstance().getAllWikis(this.context);
        }
        catch (WikiManagerException e) {
            this.logError(this.messageTool.get("wikimanager.plugin.log.wikigetall"), (XWikiException)((Object)e));
        }
        return wikiList;
    }

    public Wiki getWikiFromDocumentName(String documentFullName) throws XWikiException {
        Wiki doc = null;
        try {
            doc = WikiManager.getInstance().getWikiFromDocumentName(documentFullName, this.context);
        }
        catch (WikiManagerException e) {
            this.logError(this.messageTool.get("wikimanager.plugin.log.wikiget", documentFullName), (XWikiException)((Object)e));
        }
        return doc;
    }

    public XWikiServer getWikiDocument(String wikiName) throws XWikiException {
        return this.getWikiDocument(wikiName, 0);
    }

    public XWikiServer getWikiDocument(String wikiName, int objectId) throws XWikiException {
        XWikiServer doc = null;
        try {
            doc = WikiManager.getInstance().getWikiAlias(wikiName, objectId, true, this.context);
        }
        catch (WikiManagerException e) {
            this.logError(this.messageTool.get("wikimanager.plugin.log.wikialiasget", wikiName), (XWikiException)((Object)e));
        }
        return doc;
    }

    public List<XWikiServer> getWikiDocumentList() throws XWikiException {
        List<XWikiServer> listDocument = Collections.emptyList();
        try {
            listDocument = WikiManager.getInstance().getWikiAliasList(this.context);
        }
        catch (WikiManagerException e) {
            this.logError(this.messageTool.get("wikimanager.plugin.log.wikialiasgetall"), (XWikiException)((Object)e));
        }
        return listDocument;
    }

    public XWikiServer createWikiDocument() throws XWikiException {
        return (XWikiServer)XWikiServerClass.getInstance(this.context).newXObjectDocument(this.context);
    }

    public boolean isWikiExist(String wikiName) {
        return this.isWikiExist(wikiName, 0);
    }

    public boolean isWikiExist(String wikiName, int objectId) {
        return WikiManager.getInstance().isWikiAliasExist(wikiName, objectId, this.context);
    }

    public boolean isWikiNameAvailable(String wikiName) throws XWikiException {
        return this.context.getWiki().getStore().isWikiNameAvailable(wikiName, this.context);
    }

    public int setWikiVisibility(String wikiName, String visibility) throws XWikiException {
        return this.setWikiVisibility(wikiName, 0, visibility);
    }

    public int setWikiVisibility(String wikiName, int objectId, String visibility) throws XWikiException {
        int returncode = -1;
        try {
            XWikiServer wikiAlias = WikiManager.getInstance().getWikiAlias(wikiName, objectId, true, this.context);
            wikiAlias.setVisibility(visibility);
            wikiAlias.save();
        }
        catch (WikiManagerException e) {
            this.logError(this.messageTool.get("wikimanager.plugin.log.wikisetvisibility", wikiName), (XWikiException)((Object)e));
            returncode = e.getCode();
        }
        return returncode;
    }

    public int setIsWikiTemplate(String wikiName, boolean isWikiTemplate) throws XWikiException {
        int returncode = -1;
        try {
            Wiki wiki = WikiManager.getInstance().getWikiFromName(wikiName, this.context);
            XWikiServer wikiAlias = wiki.getFirstWikiAlias();
            wikiAlias.setIsWikiTemplate(isWikiTemplate);
            wikiAlias.save();
        }
        catch (WikiManagerException e) {
            this.logError(this.messageTool.get("wikimanager.plugin.log.wikisetvisibility", wikiName), (XWikiException)((Object)e));
            returncode = e.getCode();
        }
        return returncode;
    }

    public int createWikiTemplate(String templateName, String templateDescription, String packageName) throws XWikiException {
        if (!this.hasAdminRights()) {
            return 9001;
        }
        int returncode = -1;
        XWikiServer wikiXObjectDocument = (XWikiServer)XWikiServerClass.getInstance(this.context).newXObjectDocument(this.context);
        wikiXObjectDocument.setWikiName(templateName);
        wikiXObjectDocument.setDescription(templateDescription);
        wikiXObjectDocument.setServer(templateName + ".template.local");
        wikiXObjectDocument.setState("active");
        wikiXObjectDocument.setOwner(this.context.getUser());
        try {
            String[] params = new String[]{templateName, packageName};
            String message = this.messageTool.get("wikimanager.plugin.comment.createwikitemplate", params);
            WikiManager.getInstance().createWikiTemplate(wikiXObjectDocument, packageName, message, this.context);
        }
        catch (WikiManagerException e) {
            this.logError(this.messageTool.get("wikimanager.plugin.log.wikicreation", wikiXObjectDocument.toString()), (XWikiException)((Object)e));
            returncode = e.getCode();
        }
        return returncode;
    }

    public XWikiServer getWikiTemplateDocument(String wikiName) throws XWikiException {
        return this.getWikiTemplateDocument(wikiName, 0);
    }

    public XWikiServer getWikiTemplateDocument(String wikiName, int objectId) throws XWikiException {
        XWikiServer doc = null;
        try {
            doc = WikiManager.getInstance().getWikiTemplateAlias(wikiName, objectId, this.context, true);
        }
        catch (WikiManagerException e) {
            this.logError(this.messageTool.get("wikimanager.plugin.log.wikitemplateget", wikiName), (XWikiException)((Object)e));
        }
        return doc;
    }

    public List<XWikiServer> getWikiTemplateList() throws XWikiException {
        List<XWikiServer> listDocument = Collections.emptyList();
        try {
            listDocument = WikiManager.getInstance().getWikiTemplateAliasList(this.context);
        }
        catch (WikiManagerException e) {
            this.logError(this.messageTool.get("wikimanager.plugin.log.wikitemplategetall"), (XWikiException)((Object)e));
        }
        return listDocument;
    }
}

