/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.user.api.XWikiUser;
import java.security.Principal;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Guard;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Form;
import org.restlet.data.Request;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rest.Utils;

public class XWikiAuthentication
extends Guard {
    public XWikiAuthentication(Context context) throws IllegalArgumentException {
        super(context, ChallengeScheme.HTTP_BASIC, "XWiki");
    }

    public int authenticate(Request request) {
        if (request.getResourceRef().getPath().endsWith("/browser_authentication")) {
            return super.authenticate(request);
        }
        ComponentManager componentManager = (ComponentManager)this.getContext().getAttributes().get("xwikiComponentManager");
        XWikiContext xwikiContext = Utils.getXWikiContext(componentManager);
        XWiki xwiki = Utils.getXWiki(componentManager);
        xwikiContext.setUser("XWiki.XWikiGuest");
        Form headers = (Form)request.getAttributes().get("org.restlet.http.headers");
        if (headers.getValues("Authorization") == null) {
            try {
                XWikiUser xwikiUser = xwiki.getAuthService().checkAuth(xwikiContext);
                if (xwikiUser != null) {
                    xwikiContext.setUser(xwikiUser.getUser().contains(":") ? xwikiUser.getUser() : xwikiContext.getDatabase() + ':' + xwikiUser.getUser());
                    this.getLogger().log(Level.FINE, String.format("Authenticated as '%s'.", xwikiUser.getUser()));
                }
            }
            catch (XWikiException e) {
                this.getLogger().log(Level.WARNING, "Exception occurred while authenticating.", e);
            }
            return 1;
        }
        return super.authenticate(request);
    }

    public boolean checkSecret(Request request, String identifier, char[] secret) {
        ComponentManager componentManager = (ComponentManager)this.getContext().getAttributes().get("xwikiComponentManager");
        XWikiContext xwikiContext = Utils.getXWikiContext(componentManager);
        XWiki xwiki = Utils.getXWiki(componentManager);
        try {
            Principal principal = xwiki.getAuthService().authenticate(identifier, new String(secret), xwikiContext);
            if (principal != null) {
                String xwikiUser = principal.getName();
                xwikiContext.setUser(xwikiUser);
                this.getLogger().log(Level.FINE, String.format("Authenticated as '%s'.", identifier));
                return true;
            }
        }
        catch (XWikiException e) {
            this.getLogger().log(Level.WARNING, "Exception occurred while authenticating.", e);
        }
        this.getLogger().log(Level.WARNING, String.format("Cannot authenticate '%s'.", identifier));
        return false;
    }
}

