/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.XWiki;
import com.xpn.xwiki.doc.XWikiDocument;
import org.apache.commons.lang.StringUtils;

public class Utils {
    public static String getPageId(String wikiName, String spaceName, String pageName) {
        XWikiDocument xwikiDocument = new XWikiDocument();
        xwikiDocument.setDatabase(wikiName);
        xwikiDocument.setName(pageName);
        xwikiDocument.setSpace(spaceName);
        Document document = new Document(xwikiDocument, null);
        return document.getPrefixedFullName();
    }

    public static String getPageFullName(String wikiName, String spaceName, String pageName) {
        XWikiDocument xwikiDocument = new XWikiDocument();
        xwikiDocument.setDatabase(wikiName);
        xwikiDocument.setName(pageName);
        xwikiDocument.setSpace(spaceName);
        Document document = new Document(xwikiDocument, null);
        return document.getFullName();
    }

    public static String getObjectId(String wikiName, String spaceName, String pageName, String className, int objectNumber) {
        XWikiDocument xwikiDocument = new XWikiDocument();
        xwikiDocument.setDatabase(wikiName);
        xwikiDocument.setName(pageName);
        xwikiDocument.setSpace(spaceName);
        Document document = new Document(xwikiDocument, null);
        return String.format("%s:%s[%d]", document.getPrefixedFullName(), className, objectNumber);
    }

    public static String getPageId(String wikiName, String pageFullName) {
        XWikiDocument xwikiDocument = new XWikiDocument();
        xwikiDocument.setDatabase(wikiName);
        xwikiDocument.setFullName(pageFullName);
        Document document = new Document(xwikiDocument, null);
        return document.getPrefixedFullName();
    }

    public static Document getParentDocument(Document doc, XWiki xwikiApi) throws XWikiException {
        if (StringUtils.isEmpty((String)doc.getParent())) {
            return null;
        }
        String parentName = doc.getParent();
        if (!parentName.contains(".")) {
            parentName = doc.getSpace() + "." + parentName;
        }
        return xwikiApi.getDocument(parentName);
    }
}

