/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.ws.rs.core.Application;
import org.restlet.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWikiJaxRsApplication
extends Application {
    private static final String RESOURCES_PARAMETER = "resources";
    private static final String PROVIDERS_PARAMETER = "providers";
    private Set<Class<?>> jaxRsClasses = new HashSet();

    public XWikiJaxRsApplication(Context context) {
        String providersParameter;
        String resourcesParameter = context.getParameters().getFirstValue(RESOURCES_PARAMETER);
        if (resourcesParameter != null) {
            String[] resourceClassNames;
            for (String resourceClassName : resourceClassNames = resourcesParameter.split(";")) {
                try {
                    resourceClassName = resourceClassName.trim();
                    Class<?> resourceClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(resourceClassName);
                    this.jaxRsClasses.add(resourceClass);
                    context.getLogger().log(Level.FINE, String.format("Added resource %s", resourceClassName));
                }
                catch (ClassNotFoundException e) {
                    context.getLogger().log(Level.WARNING, String.format("Cannot load class %s", resourceClassName));
                }
            }
        }
        if ((providersParameter = context.getParameters().getFirstValue(PROVIDERS_PARAMETER)) != null) {
            String[] providerClassNames;
            for (String providerClassName : providerClassNames = providersParameter.split(";")) {
                try {
                    providerClassName = providerClassName.trim();
                    Class<?> providerClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(providerClassName);
                    this.jaxRsClasses.add(providerClass);
                    context.getLogger().log(Level.FINE, String.format("Added provider %s", providerClassName));
                }
                catch (ClassNotFoundException e) {
                    context.getLogger().log(Level.WARNING, String.format("Cannot load class %s", providerClassName));
                }
            }
        }
        context.getLogger().log(Level.INFO, "RESTful API subsystem initialized.");
    }

    public Set<Class<?>> getClasses() {
        return this.jaxRsClasses;
    }
}

