/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest;

import com.noelios.restlet.ext.servlet.ServletCall;
import com.noelios.restlet.ext.servlet.ServletContextAdapter;
import com.noelios.restlet.http.HttpCall;
import com.noelios.restlet.http.HttpRequest;
import com.noelios.restlet.http.HttpResponse;
import com.noelios.restlet.http.HttpServerCall;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.api.XWiki;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiEngineContext;
import com.xpn.xwiki.web.XWikiRequest;
import com.xpn.xwiki.web.XWikiResponse;
import com.xpn.xwiki.web.XWikiServletContext;
import com.xpn.xwiki.web.XWikiServletRequest;
import com.xpn.xwiki.web.XWikiServletResponse;
import com.xpn.xwiki.web.XWikiURLFactory;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.restlet.Filter;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.xwiki.container.Container;
import org.xwiki.container.servlet.ServletContainerException;
import org.xwiki.container.servlet.ServletContainerInitializer;
import org.xwiki.context.Execution;

public class XWikiSetupCleanupFilter
extends Filter {
    protected int beforeHandle(Request request, Response response) {
        XWikiContext xwikiContext = null;
        XWikiServletRequest xwikiRequest = new XWikiServletRequest(XWikiSetupCleanupFilter.getHttpRequest(request));
        XWikiServletResponse xwikiResponse = new XWikiServletResponse(XWikiSetupCleanupFilter.getHttpResponse(response));
        ServletContextAdapter adapter = (ServletContextAdapter)this.getContext();
        ServletContext servletContext = adapter.getServletContext();
        XWikiServletContext xwikiServletContext = new XWikiServletContext(servletContext);
        try {
            xwikiContext = Utils.prepareContext((String)"", (XWikiRequest)xwikiRequest, (XWikiResponse)xwikiResponse, (XWikiEngineContext)xwikiServletContext);
            this.initializeContainerComponent(xwikiContext);
            com.xpn.xwiki.XWiki xwiki = com.xpn.xwiki.XWiki.getXWiki((XWikiContext)xwikiContext);
            XWikiURLFactory urlf = xwiki.getURLFactoryService().createURLFactory(xwikiContext.getMode(), xwikiContext);
            xwikiContext.setURLFactory(urlf);
            XWiki xwikiApi = new XWiki(xwiki, xwikiContext);
            String xwikiUser = "XWiki.XWikiGuest";
            xwikiContext.setUser(xwikiUser);
            ConcurrentMap attributes = this.getContext().getAttributes();
            attributes.put("xwikiContext", xwikiContext);
            attributes.put("xwiki", xwiki);
            attributes.put("xwikiApi", xwikiApi);
            attributes.put("xwikiUser", xwikiUser);
            attributes.put("httpRequest", XWikiSetupCleanupFilter.getHttpRequest(request));
        }
        catch (Exception e) {
            if (xwikiContext != null) {
                this.cleanupComponents();
            }
            this.getLogger().log(Level.SEVERE, "Cannot initialize XWiki context.", e);
            return 2;
        }
        this.getLogger().log(Level.FINE, "XWiki context initialized.");
        return 0;
    }

    protected void afterHandle(Request request, Response response) {
        XWikiContext xwikiContext = (XWikiContext)this.getContext().getAttributes().get("xwikiContext");
        if (xwikiContext != null) {
            this.getLogger().log(Level.FINE, "XWiki context cleaned up.");
            this.cleanupComponents();
        }
        ConcurrentMap attributes = this.getContext().getAttributes();
        attributes.remove("xwikiContext");
        attributes.remove("xwiki");
        attributes.remove("xwikiApi");
        attributes.remove("xwikiUser");
        attributes.remove("httpRequest");
        if (response.getEntity() != null && !response.getEntity().isAvailable()) {
            response.setEntity(null);
        }
    }

    private void initializeContainerComponent(XWikiContext context) throws ServletException {
        ServletContainerInitializer containerInitializer = (ServletContainerInitializer)Utils.getComponent(ServletContainerInitializer.class);
        try {
            containerInitializer.initializeRequest(context.getRequest().getHttpServletRequest(), (Object)context);
            containerInitializer.initializeResponse(context.getResponse().getHttpServletResponse());
            containerInitializer.initializeSession(context.getRequest().getHttpServletRequest());
        }
        catch (ServletContainerException e) {
            throw new ServletException("Failed to initialize request/response or session", (Throwable)e);
        }
    }

    private void cleanupComponents() {
        Container container = (Container)Utils.getComponent(Container.class);
        Execution execution = (Execution)Utils.getComponent(Execution.class);
        container.removeRequest();
        container.removeResponse();
        container.removeSession();
        execution.removeContext();
    }

    protected static HttpServletRequest getHttpRequest(Request req) {
        HttpRequest httpRequest;
        HttpCall httpCall;
        if (req instanceof HttpRequest && (httpCall = (httpRequest = (HttpRequest)req).getHttpCall()) instanceof ServletCall) {
            return ((ServletCall)httpCall).getRequest();
        }
        return null;
    }

    protected static HttpServletResponse getHttpResponse(Response res) {
        HttpResponse httpResponse;
        HttpServerCall httpCall;
        if (res instanceof HttpResponse && (httpCall = (httpResponse = (HttpResponse)res).getHttpCall()) instanceof ServletCall) {
            return ((ServletCall)httpCall).getResponse();
        }
        return null;
    }
}

