/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.resources;

import com.xpn.xwiki.XWikiException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.rest.Utils;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.SearchResult;
import org.xwiki.rest.resources.objects.ObjectResource;
import org.xwiki.rest.resources.pages.PageResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseSearchResult
extends XWikiResource {
    protected List<SearchResult> searchPages(List<SearchScope> searchScopes, String keywords, String wikiName, String space, boolean hasProgrammingRights, int number) throws QueryException, IllegalArgumentException, UriBuilderException, XWikiException {
        ArrayList<SearchResult> result = new ArrayList<SearchResult>();
        if (keywords == null) {
            return result;
        }
        Formatter f = new Formatter();
        if (space != null) {
            f.format("select doc.space, doc.name from XWikiDocument as doc where doc.space = :space and ( ", new Object[0]);
        } else {
            f.format("select doc.space, doc.name from XWikiDocument as doc where ( ", new Object[0]);
        }
        int acceptedScopes = 0;
        for (int i = 0; i < searchScopes.size(); ++i) {
            SearchScope scope = searchScopes.get(i);
            switch (scope) {
                case CONTENT: {
                    f.format("upper(doc.content) like :keywords ", new Object[0]);
                    ++acceptedScopes;
                    break;
                }
                case NAME: {
                    f.format("upper(doc.fullName) like :keywords ", new Object[0]);
                    ++acceptedScopes;
                    break;
                }
                case TITLE: {
                    f.format("upper(doc.title) like :keywords ", new Object[0]);
                    ++acceptedScopes;
                }
            }
            if (i == searchScopes.size() - 1) continue;
            f.format(" or ", new Object[0]);
        }
        if (acceptedScopes == 0) {
            return result;
        }
        if (hasProgrammingRights) {
            f.format(") order by doc.date desc", new Object[0]);
        } else {
            f.format(") and doc.space<>'XWiki' and doc.space<>'Admin' and doc.space<>'Panels' and doc.name<>'WebPreferences' order by doc.date desc", new Object[0]);
        }
        String query = f.toString();
        QueryManager queryManager = (QueryManager)com.xpn.xwiki.web.Utils.getComponent(QueryManager.class);
        List queryResult = null;
        queryResult = space != null ? queryManager.createQuery(query, "xwql").bindValue("keywords", (Object)String.format("%%%s%%", keywords.toUpperCase())).bindValue("space", (Object)space).setLimit(number).execute() : queryManager.createQuery(query, "xwql").bindValue("keywords", (Object)String.format("%%%s%%", keywords.toUpperCase())).setLimit(number).execute();
        for (Object object : queryResult) {
            String pageName;
            Object[] fields = (Object[])object;
            String spaceName = (String)fields[0];
            String pageId = Utils.getPageId(wikiName, spaceName, pageName = (String)fields[1]);
            if (!this.xwikiApi.hasAccessLevel("view", pageId)) continue;
            SearchResult searchResult = this.objectFactory.createSearchResult();
            searchResult.setType("page");
            searchResult.setId(pageId);
            searchResult.setPageFullName(Utils.getPageFullName(wikiName, spaceName, pageName));
            searchResult.setWiki(wikiName);
            searchResult.setSpace(spaceName);
            searchResult.setPageName(pageName);
            String pageUri = UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(PageResource.class).build(new Object[]{wikiName, spaceName, pageName}).toString();
            Link pageLink = new Link();
            pageLink.setHref(pageUri);
            pageLink.setRel("http://www.xwiki.org/rel/page");
            searchResult.getLinks().add(pageLink);
            result.add(searchResult);
        }
        return result;
    }

    protected List<SearchResult> searchObjects(String keywords, String wikiName, String space, boolean hasProgrammingRights, int number) throws QueryException, IllegalArgumentException, UriBuilderException, XWikiException {
        ArrayList<String> addedIds = new ArrayList<String>();
        ArrayList<SearchResult> result = new ArrayList<SearchResult>();
        if (keywords == null) {
            return result;
        }
        Formatter f = new Formatter();
        if (space != null) {
            f.format("select doc.space, doc.name, obj.className, obj.number from XWikiDocument as doc, BaseObject as obj, StringProperty as sp, LargeStringProperty as lsp where doc.space = :space and obj.name=doc.fullName and sp.id.id = obj.id and lsp.id.id = obj.id and (upper(sp.value) like :keywords or upper(lsp.value) like :keywords) ", new Object[0]);
        } else {
            f.format("select doc.space, doc.name, obj.className, obj.number from XWikiDocument as doc, BaseObject as obj, StringProperty as sp, LargeStringProperty as lsp where obj.name=doc.fullName and sp.id.id = obj.id and lsp.id.id = obj.id and (upper(sp.value) like :keywords or upper(lsp.value) like :keywords) ", new Object[0]);
        }
        if (hasProgrammingRights) {
            f.format(" order by doc.date desc", new Object[0]);
        } else {
            f.format(" and doc.space<>'XWiki' and doc.space<>'Admin' and doc.space<>'Panels' and doc.name<>'WebPreferences' order by doc.date desc", new Object[0]);
        }
        String query = f.toString();
        System.out.format("Query: %s\n", query);
        QueryManager queryManager = (QueryManager)com.xpn.xwiki.web.Utils.getComponent(QueryManager.class);
        List queryResult = null;
        queryResult = space != null ? queryManager.createQuery(query, "xwql").bindValue("keywords", (Object)String.format("%%%s%%", keywords.toUpperCase())).bindValue("space", (Object)space).setLimit(number).execute() : queryManager.createQuery(query, "xwql").bindValue("keywords", (Object)String.format("%%%s%%", keywords.toUpperCase())).setLimit(number).execute();
        for (Object object : queryResult) {
            String pageId;
            int objectNumber;
            String className;
            String pageName;
            Object[] fields = (Object[])object;
            String spaceName = (String)fields[0];
            String id = Utils.getObjectId(wikiName, spaceName, pageName = (String)fields[1], className = (String)fields[2], objectNumber = ((Integer)fields[3]).intValue());
            if (addedIds.contains(id) || !this.xwikiApi.hasAccessLevel("view", pageId = Utils.getPageId(wikiName, spaceName, pageName))) continue;
            SearchResult searchResult = this.objectFactory.createSearchResult();
            searchResult.setType("object");
            searchResult.setId(id);
            searchResult.setPageFullName(Utils.getPageFullName(wikiName, spaceName, pageName));
            searchResult.setWiki(wikiName);
            searchResult.setSpace(spaceName);
            searchResult.setPageName(pageName);
            searchResult.setClassName(className);
            searchResult.setObjectNumber(objectNumber);
            String pageUri = UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(PageResource.class).build(new Object[]{wikiName, spaceName, pageName}).toString();
            Link pageLink = new Link();
            pageLink.setHref(pageUri);
            pageLink.setRel("http://www.xwiki.org/rel/page");
            searchResult.getLinks().add(pageLink);
            String objectUri = UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(ObjectResource.class).build(new Object[]{wikiName, spaceName, pageName, className, objectNumber}).toString();
            Link objectLink = new Link();
            objectLink.setHref(objectUri);
            objectLink.setRel("http://www.xwiki.org/rel/object");
            searchResult.getLinks().add(objectLink);
            result.add(searchResult);
            addedIds.add(id);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum SearchScope {
        NAME,
        CONTENT,
        TITLE,
        OBJECTS;

    }
}

