/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.resources.attachments;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Attachment;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.ArrayList;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.suigeneris.jrcs.rcs.Version;
import org.xwiki.rest.DomainObjectFactory;
import org.xwiki.rest.RangeIterable;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.model.jaxb.Attachments;

@Path(value="/wikis/{wikiName}/spaces/{spaceName}/pages/{pageName}/attachments/{attachmentName}/history")
public class AttachmentHistoryResource
extends XWikiResource {
    @GET
    public Attachments getAttachmentHistory(@PathParam(value="wikiName") String wikiName, @PathParam(value="spaceName") String spaceName, @PathParam(value="pageName") String pageName, @PathParam(value="attachmentName") String attachmentName, @QueryParam(value="start") @DefaultValue(value="0") Integer start, @QueryParam(value="number") @DefaultValue(value="-1") Integer number) throws XWikiException {
        XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, false);
        Document doc = documentInfo.getDocument();
        Attachment xwikiAttachment = doc.getAttachment(attachmentName);
        if (xwikiAttachment == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        XWikiDocument xwikiDocument = this.xwiki.getDocument(doc.getPrefixedFullName(), this.xwikiContext);
        Attachments attachments = new Attachments();
        Version[] versions = xwikiAttachment.getVersions();
        ArrayList<Version> versionList = new ArrayList<Version>();
        for (Version version : versions) {
            versionList.add(version);
        }
        RangeIterable ri = new RangeIterable(versionList, start, number);
        for (Version version : ri) {
            Attachment xwikiAttachmentAtVersion = xwikiAttachment.getAttachmentRevision(version.toString());
            String attachmentXWikiAbsoluteUrl = xwikiDocument.getExternalAttachmentURL(attachmentName, "download", this.xwikiContext).toString();
            String attachmentXWikiRelativeUrl = xwikiDocument.getAttachmentURL(attachmentName, "download", this.xwikiContext).toString();
            attachments.getAttachments().add(DomainObjectFactory.createAttachmentAtVersion(this.objectFactory, this.uriInfo.getBaseUri(), xwikiAttachmentAtVersion, attachmentXWikiRelativeUrl, attachmentXWikiAbsoluteUrl));
        }
        return attachments;
    }
}

